/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.dataset.DatasetDirectoryRecord;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.dataset.IDatasetDirectoryService;
import edu.uci.ics.hyracks.control.common.work.IResultCallback;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;

public class GetResultPartitionLocationsWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final JobId jobId;
    private final ResultSetId rsId;
    private final DatasetDirectoryRecord[] knownRecords;
    private final IResultCallback<DatasetDirectoryRecord[]> callback;

    public GetResultPartitionLocationsWork(ClusterControllerService ccs, JobId jobId, ResultSetId rsId, DatasetDirectoryRecord[] knownRecords, IResultCallback<DatasetDirectoryRecord[]> callback) {
        this.ccs = ccs;
        this.jobId = jobId;
        this.rsId = rsId;
        this.knownRecords = knownRecords;
        this.callback = callback;
    }

    public void doRun() {
        final IDatasetDirectoryService dds = this.ccs.getDatasetDirectoryService();
        this.ccs.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DatasetDirectoryRecord[] partitionLocations = dds.getResultPartitionLocations(GetResultPartitionLocationsWork.this.jobId, GetResultPartitionLocationsWork.this.rsId, GetResultPartitionLocationsWork.this.knownRecords);
                    GetResultPartitionLocationsWork.this.callback.setValue((Object)partitionLocations);
                }
                catch (HyracksDataException e) {
                    GetResultPartitionLocationsWork.this.callback.setException((Exception)((Object)e));
                }
            }
        });
    }
}

