/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import java.util.Collection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetJobSummariesJSONWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private JSONArray summaries;

    public GetJobSummariesJSONWork(ClusterControllerService ccs) {
        this.ccs = ccs;
    }

    protected void doRun() throws Exception {
        this.summaries = new JSONArray();
        this.populateJSON(this.ccs.getActiveRunMap().values());
        this.populateJSON(this.ccs.getRunMapArchive().values());
    }

    private void populateJSON(Collection<JobRun> jobRuns) throws JSONException {
        for (JobRun run : jobRuns) {
            JSONObject jo = new JSONObject();
            jo.put("type", (Object)"job-summary");
            jo.put("job-id", (Object)run.getJobId().toString());
            jo.put("create-time", run.getCreateTime());
            jo.put("start-time", run.getCreateTime());
            jo.put("end-time", run.getCreateTime());
            jo.put("status", (Object)run.getStatus().toString());
            this.summaries.put((Object)jo);
        }
    }

    public JSONArray getSummaries() {
        return this.summaries;
    }
}

