/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.NodeControllerState;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class GatherStateDumpsWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final StateDumpRun sdr;

    public GatherStateDumpsWork(ClusterControllerService ccs) {
        this.ccs = ccs;
        this.sdr = new StateDumpRun(ccs);
    }

    public void doRun() throws Exception {
        this.ccs.addStateDumpRun(this.sdr.stateDumpId, this.sdr);
        this.sdr.setNCs(new HashSet<String>(this.ccs.getNodeMap().keySet()));
        for (NodeControllerState ncs : this.ccs.getNodeMap().values()) {
            ncs.getNodeController().dumpState(this.sdr.stateDumpId);
        }
    }

    public StateDumpRun getStateDumpRun() {
        return this.sdr;
    }

    public static class StateDumpRun {
        private final ClusterControllerService ccs;
        private final String stateDumpId;
        private final Map<String, String> ncStates;
        private Set<String> ncIds;
        private boolean complete;

        public StateDumpRun(ClusterControllerService ccs) {
            this.ccs = ccs;
            this.stateDumpId = UUID.randomUUID().toString();
            this.ncStates = new HashMap<String, String>();
            this.complete = false;
        }

        public void setNCs(Set<String> ncIds) {
            this.ncIds = ncIds;
        }

        public Map<String, String> getStateDump() {
            return this.ncStates;
        }

        public synchronized void notifyStateDumpReceived(String nodeId, String state) {
            this.ncIds.remove(nodeId);
            this.ncStates.put(nodeId, state);
            if (this.ncIds.size() == 0) {
                this.complete = true;
                this.ccs.removeStateDumpRun(this.stateDumpId);
                this.notifyAll();
            }
        }

        public synchronized void waitForCompletion() throws InterruptedException {
            while (!this.complete) {
                this.wait();
            }
        }

        public String getStateDumpId() {
            return this.stateDumpId;
        }
    }
}

