/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.job.IJobSerializerDeserializerContainer;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.NodeControllerState;
import edu.uci.ics.hyracks.control.common.context.ServerContext;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentRun;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentUtils;
import edu.uci.ics.hyracks.control.common.work.IPCResponder;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;

public class CliUnDeployBinaryWork
extends SynchronizableWork {
    private ClusterControllerService ccs;
    private DeploymentId deploymentId;
    private IPCResponder<DeploymentId> callback;

    public CliUnDeployBinaryWork(ClusterControllerService ncs, DeploymentId deploymentId, IPCResponder<DeploymentId> callback) {
        this.ccs = ncs;
        this.deploymentId = deploymentId;
        this.callback = callback;
    }

    public void doRun() {
        try {
            if (this.deploymentId == null) {
                this.deploymentId = new DeploymentId(UUID.randomUUID().toString());
            }
            DeploymentUtils.undeploy((DeploymentId)this.deploymentId, (IJobSerializerDeserializerContainer)this.ccs.getApplicationContext().getJobSerializerDeserializerContainer(), (ServerContext)this.ccs.getServerContext());
            Map<String, NodeControllerState> nodeControllerStateMap = this.ccs.getNodeMap();
            TreeSet<String> nodeIds = new TreeSet<String>();
            for (String nc : nodeControllerStateMap.keySet()) {
                nodeIds.add(nc);
            }
            final DeploymentRun dRun = new DeploymentRun(nodeIds);
            this.ccs.addDeploymentRun(this.deploymentId, dRun);
            for (NodeControllerState ncs : nodeControllerStateMap.values()) {
                ncs.getNodeController().undeployBinary(this.deploymentId);
            }
            this.ccs.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        dRun.waitForCompletion();
                        CliUnDeployBinaryWork.this.ccs.removeDeploymentRun(CliUnDeployBinaryWork.this.deploymentId);
                        CliUnDeployBinaryWork.this.callback.setValue(null);
                    }
                    catch (Exception e) {
                        CliUnDeployBinaryWork.this.callback.setException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

