/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.job.IJobSerializerDeserializerContainer;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.NodeControllerState;
import edu.uci.ics.hyracks.control.common.context.ServerContext;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentRun;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentUtils;
import edu.uci.ics.hyracks.control.common.work.IPCResponder;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;

public class CliDeployBinaryWork
extends SynchronizableWork {
    private ClusterControllerService ccs;
    private List<URL> binaryURLs;
    private DeploymentId deploymentId;
    private IPCResponder<DeploymentId> callback;

    public CliDeployBinaryWork(ClusterControllerService ncs, List<URL> binaryURLs, DeploymentId deploymentId, IPCResponder<DeploymentId> callback) {
        this.ccs = ncs;
        this.binaryURLs = binaryURLs;
        this.deploymentId = deploymentId;
        this.callback = callback;
    }

    public void doRun() {
        try {
            if (this.deploymentId == null) {
                this.deploymentId = new DeploymentId(UUID.randomUUID().toString());
            }
            DeploymentUtils.deploy((DeploymentId)this.deploymentId, this.binaryURLs, (IJobSerializerDeserializerContainer)this.ccs.getApplicationContext().getJobSerializerDeserializerContainer(), (ServerContext)this.ccs.getServerContext(), (boolean)false);
            Map<String, NodeControllerState> nodeControllerStateMap = this.ccs.getNodeMap();
            TreeSet<String> nodeIds = new TreeSet<String>();
            for (String nc : nodeControllerStateMap.keySet()) {
                nodeIds.add(nc);
            }
            final DeploymentRun dRun = new DeploymentRun(nodeIds);
            this.ccs.addDeploymentRun(this.deploymentId, dRun);
            for (NodeControllerState ncs : nodeControllerStateMap.values()) {
                ncs.getNodeController().deployBinary(this.deploymentId, this.binaryURLs);
            }
            this.ccs.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        dRun.waitForCompletion();
                        CliDeployBinaryWork.this.ccs.removeDeploymentRun(CliDeployBinaryWork.this.deploymentId);
                        CliDeployBinaryWork.this.callback.setValue((Object)CliDeployBinaryWork.this.deploymentId);
                    }
                    catch (Exception e) {
                        CliDeployBinaryWork.this.callback.setException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.callback.setException(e);
        }
    }
}

