/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.application.IApplicationContext;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.messages.IMessage;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.application.CCApplicationContext;
import edu.uci.ics.hyracks.control.cc.work.AbstractHeartbeatWork;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationMessageWork
extends AbstractHeartbeatWork {
    private static final Logger LOGGER = Logger.getLogger(ApplicationMessageWork.class.getName());
    private byte[] message;
    private DeploymentId deploymentId;
    private String nodeId;
    private ClusterControllerService ccs;

    public ApplicationMessageWork(ClusterControllerService ccs, byte[] message, DeploymentId deploymentId, String nodeId) {
        super(ccs, nodeId, null);
        this.ccs = ccs;
        this.deploymentId = deploymentId;
        this.nodeId = nodeId;
        this.message = message;
    }

    @Override
    public void runWork() {
        final CCApplicationContext ctx = this.ccs.getApplicationContext();
        try {
            final IMessage data = (IMessage)DeploymentUtils.deserialize((byte[])this.message, (DeploymentId)this.deploymentId, (IApplicationContext)ctx);
            this.ccs.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ctx.getMessageBroker().receivedMessage(data, ApplicationMessageWork.this.nodeId);
                }
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error in stats reporting", e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "nodeID: " + this.nodeId;
    }
}

