/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.job.ActivityCluster;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.job.ActivityPlan;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.cc.job.Task;
import edu.uci.ics.hyracks.control.cc.job.TaskAttempt;
import edu.uci.ics.hyracks.control.cc.job.TaskCluster;
import edu.uci.ics.hyracks.control.cc.job.TaskClusterAttempt;
import edu.uci.ics.hyracks.control.cc.work.AbstractHeartbeatWork;
import java.util.List;
import java.util.Map;

public abstract class AbstractTaskLifecycleWork
extends AbstractHeartbeatWork {
    protected final ClusterControllerService ccs;
    protected final JobId jobId;
    protected final TaskAttemptId taId;
    protected final String nodeId;

    public AbstractTaskLifecycleWork(ClusterControllerService ccs, JobId jobId, TaskAttemptId taId, String nodeId) {
        super(ccs, nodeId, null);
        this.ccs = ccs;
        this.jobId = jobId;
        this.taId = taId;
        this.nodeId = nodeId;
    }

    @Override
    public final void runWork() {
        JobRun run = this.ccs.getActiveRunMap().get(this.jobId);
        if (run != null) {
            TaskClusterAttempt tca;
            TaskAttempt ta;
            Task ts;
            TaskCluster tc;
            List<TaskClusterAttempt> taskClusterAttempts;
            Map<ActivityId, ActivityPlan> taskStateMap;
            Task[] taskStates;
            TaskId tid = this.taId.getTaskId();
            Map activityClusterMap = run.getActivityClusterGraph().getActivityMap();
            ActivityCluster ac = (ActivityCluster)activityClusterMap.get(tid.getActivityId());
            if (ac != null && (taskStates = (taskStateMap = run.getActivityClusterPlanMap().get(ac.getId()).getActivityPlanMap()).get(tid.getActivityId()).getTasks()) != null && taskStates.length > tid.getPartition() && (taskClusterAttempts = (tc = (ts = taskStates[tid.getPartition()]).getTaskCluster()).getAttempts()) != null && taskClusterAttempts.size() > this.taId.getAttempt() && (ta = (tca = taskClusterAttempts.get(this.taId.getAttempt())).getTaskAttempts().get(tid)) != null) {
                this.performEvent(ta);
            }
        }
    }

    protected abstract void performEvent(TaskAttempt var1);
}

