/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.NodeControllerState;
import edu.uci.ics.hyracks.control.common.heartbeat.HeartbeatData;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import java.util.Map;

public abstract class AbstractHeartbeatWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final String nodeId;
    private final HeartbeatData hbData;

    public AbstractHeartbeatWork(ClusterControllerService ccs, String nodeId, HeartbeatData hbData) {
        this.ccs = ccs;
        this.nodeId = nodeId;
        this.hbData = hbData;
    }

    public void doRun() {
        Map<String, NodeControllerState> nodeMap = this.ccs.getNodeMap();
        NodeControllerState state = nodeMap.get(this.nodeId);
        if (state != null) {
            state.notifyHeartbeat(this.hbData);
        }
        this.runWork();
    }

    public abstract void runWork();
}

