/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.web;

import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.adminconsole.HyracksAdminConsoleApplication;
import edu.uci.ics.hyracks.control.cc.web.ApplicationInstallationHandler;
import edu.uci.ics.hyracks.control.cc.web.JobsRESTAPIFunction;
import edu.uci.ics.hyracks.control.cc.web.NodesRESTAPIFunction;
import edu.uci.ics.hyracks.control.cc.web.StateDumpRESTAPIFunction;
import edu.uci.ics.hyracks.control.cc.web.util.JSONOutputRequestHandler;
import edu.uci.ics.hyracks.control.cc.web.util.RoutingHandler;
import java.util.EnumSet;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.protocol.http.WicketFilter;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class WebServer {
    private static final Logger LOGGER = Logger.getLogger(WebServer.class.getName());
    private final ClusterControllerService ccs;
    private final Server server;
    private final SelectChannelConnector connector;
    private final HandlerCollection handlerCollection;

    public WebServer(ClusterControllerService ccs) throws Exception {
        this.ccs = ccs;
        this.server = new Server();
        this.connector = new SelectChannelConnector();
        this.server.setConnectors(new Connector[]{this.connector});
        this.handlerCollection = new ContextHandlerCollection();
        this.server.setHandler((Handler)this.handlerCollection);
        this.addHandlers();
    }

    private void addHandlers() {
        ContextHandler handler = new ContextHandler("/rest");
        RoutingHandler rh = new RoutingHandler();
        rh.addHandler("jobs", (Handler)new JSONOutputRequestHandler(new JobsRESTAPIFunction(this.ccs)));
        rh.addHandler("nodes", (Handler)new JSONOutputRequestHandler(new NodesRESTAPIFunction(this.ccs)));
        rh.addHandler("statedump", (Handler)new JSONOutputRequestHandler(new StateDumpRESTAPIFunction(this.ccs)));
        handler.setHandler((Handler)rh);
        this.addHandler((Handler)handler);
        this.addHandler(this.createAdminConsoleHandler());
        this.addHandler(this.createStaticResourcesHandler());
        handler = new ContextHandler("/applications");
        handler.setHandler((Handler)new ApplicationInstallationHandler(this.ccs));
        this.addHandler((Handler)handler);
    }

    private Handler createAdminConsoleHandler() {
        FilterHolder filter = new FilterHolder(WicketFilter.class);
        filter.setInitParameter("applicationClassName", HyracksAdminConsoleApplication.class.getName());
        filter.setInitParameter("filterMappingUrlPattern", "/*");
        filter.setInitParameter("configuration", RuntimeConfigurationType.DEPLOYMENT.toString());
        ServletContextHandler handler = new ServletContextHandler(1);
        handler.setContextPath("/adminconsole");
        handler.setAttribute(ClusterControllerService.class.getName(), (Object)this.ccs);
        handler.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR));
        handler.addServlet(DefaultServlet.class, "/");
        return handler;
    }

    private Handler createStaticResourcesHandler() {
        String staticDir = WebServer.class.getClassLoader().getResource("static").toExternalForm();
        ServletContextHandler handler = new ServletContextHandler(1);
        handler.setContextPath("/static");
        handler.setResourceBase(staticDir);
        handler.addServlet(DefaultServlet.class, "/");
        return handler;
    }

    public void setPort(int port) {
        this.connector.setPort(port);
    }

    public int getListeningPort() {
        return this.connector.getLocalPort();
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public void addHandler(Handler handler) {
        this.handlerCollection.addHandler(handler);
    }
}

