/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.web;

import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ApplicationInstallationHandler
extends AbstractHandler {
    private ClusterControllerService ccs;

    public ApplicationInstallationHandler(ClusterControllerService ccs) {
        this.ccs = ccs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String deploymentDir;
            while (target.startsWith("/")) {
                target = target.substring(1);
            }
            while (target.endsWith("/")) {
                target = target.substring(0, target.length() - 1);
            }
            String[] parts = target.split("/");
            if (parts.length != 1) {
                return;
            }
            final String[] params = parts[0].split("&");
            String deployIdString = params[0];
            String rootDir = this.ccs.getServerContext().getBaseDir().toString();
            String string = deploymentDir = rootDir.endsWith(File.separator) ? rootDir + "applications/" + deployIdString : rootDir + File.separator + "/applications/" + File.separator + deployIdString;
            if ("PUT".equals(request.getMethod())) {
                class OutputStreamGetter
                extends SynchronizableWork {
                    private OutputStream os;

                    OutputStreamGetter() {
                    }

                    protected void doRun() throws Exception {
                        FileUtils.forceMkdir((File)new File(deploymentDir));
                        String fileName = params[1];
                        File jarFile = new File(deploymentDir, fileName);
                        this.os = new FileOutputStream(jarFile);
                    }
                }
                OutputStreamGetter r = new OutputStreamGetter();
                try {
                    this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)r);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                try {
                    IOUtils.copyLarge((InputStream)request.getInputStream(), (OutputStream)r.os);
                }
                finally {
                    r.os.close();
                }
            }
            if ("GET".equals(request.getMethod())) {
                class InputStreamGetter
                extends SynchronizableWork {
                    private InputStream is;

                    InputStreamGetter() {
                    }

                    protected void doRun() throws Exception {
                        String fileName = params[1];
                        File jarFile = new File(deploymentDir, fileName);
                        this.is = new FileInputStream(jarFile);
                    }
                }
                InputStreamGetter r = new InputStreamGetter();
                try {
                    this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)r);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                if (r.is == null) {
                    response.setStatus(404);
                } else {
                    response.setContentType("application/octet-stream");
                    response.setStatus(200);
                    try {
                        IOUtils.copyLarge((InputStream)r.is, (OutputStream)response.getOutputStream());
                    }
                    finally {
                        r.is.close();
                    }
                }
            }
            baseRequest.setHandled(true);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

