/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.scheduler;

import edu.uci.ics.hyracks.api.constraints.Constraint;
import edu.uci.ics.hyracks.api.constraints.expressions.ConstantExpression;
import edu.uci.ics.hyracks.api.constraints.expressions.ConstraintExpression;
import edu.uci.ics.hyracks.api.constraints.expressions.LValueConstraintExpression;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PartitionConstraintSolver {
    private final Map<LValueConstraintExpression, Set<ConstraintExpression>> constraints = new HashMap<LValueConstraintExpression, Set<ConstraintExpression>>();

    public void addConstraints(Collection<Constraint> constraintCollection) {
        for (Constraint c : constraintCollection) {
            this.addConstraint(c);
        }
    }

    public void addConstraint(Constraint c) {
        Set<ConstraintExpression> rValues = this.constraints.get(c.getLValue());
        if (rValues == null) {
            rValues = new HashSet<ConstraintExpression>();
            this.constraints.put(c.getLValue(), rValues);
        }
        rValues.add(c.getRValue());
    }

    public void solve(Collection<LValueConstraintExpression> targetSet) {
        HashSet<LValueConstraintExpression> inProcess = new HashSet<LValueConstraintExpression>();
        for (LValueConstraintExpression lv : targetSet) {
            this.solveLValue(lv, inProcess);
        }
    }

    private Solution solve(ConstraintExpression ce, Set<LValueConstraintExpression> inProcess) {
        switch (ce.getTag()) {
            case CONSTANT: {
                return new Solution(((ConstantExpression)ce).getValue(), Solution.Status.FOUND);
            }
            case PARTITION_COUNT: 
            case PARTITION_LOCATION: {
                return this.solveLValue((LValueConstraintExpression)ce, inProcess);
            }
        }
        return null;
    }

    private Solution solveLValue(LValueConstraintExpression lv, Set<LValueConstraintExpression> inProcess) {
        if (inProcess.contains(lv)) {
            return new Solution(null, Solution.Status.CYCLE);
        }
        Solution result = null;
        inProcess.add(lv);
        Set<ConstraintExpression> rValues = this.constraints.get(lv);
        if (rValues == null) {
            return new Solution(null, Solution.Status.NOT_BOUND);
        }
        for (ConstraintExpression ce : rValues) {
            Solution solution = this.solve(ce, inProcess);
            if (solution == null || solution.status != Solution.Status.FOUND) continue;
            result = solution;
            break;
        }
        if (result != null) {
            rValues.clear();
            rValues.add((ConstraintExpression)new ConstantExpression(result.value));
        }
        inProcess.remove(lv);
        return result;
    }

    public Object getValue(LValueConstraintExpression lValue) {
        Set<ConstraintExpression> rValues = this.constraints.get(lValue);
        if (rValues == null) {
            return null;
        }
        if (rValues.size() != 1) {
            return null;
        }
        for (ConstraintExpression ce : rValues) {
            if (ce.getTag() != ConstraintExpression.ExpressionTag.CONSTANT) continue;
            return ((ConstantExpression)ce).getValue();
        }
        return null;
    }

    private static class Solution {
        final Object value;
        final Status status;

        public Solution(Object value, Status status) {
            this.value = value;
            this.status = status;
        }

        static enum Status {
            FOUND,
            CYCLE,
            NOT_BOUND;

        }
    }
}

