/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.scheduler;

import edu.uci.ics.hyracks.api.constraints.expressions.LValueConstraintExpression;
import edu.uci.ics.hyracks.api.constraints.expressions.PartitionCountExpression;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.ConnectorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.IConnectorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.OperatorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.connectors.IConnectorPolicy;
import edu.uci.ics.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import edu.uci.ics.hyracks.api.dataflow.connectors.PipeliningConnectorPolicy;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.ActivityCluster;
import edu.uci.ics.hyracks.api.job.ActivityClusterGraph;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.control.cc.job.ActivityClusterPlan;
import edu.uci.ics.hyracks.control.cc.job.ActivityPlan;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.cc.job.Task;
import edu.uci.ics.hyracks.control.cc.job.TaskCluster;
import edu.uci.ics.hyracks.control.cc.job.TaskClusterId;
import edu.uci.ics.hyracks.control.cc.scheduler.ActivityPartitionDetails;
import edu.uci.ics.hyracks.control.cc.scheduler.JobScheduler;
import edu.uci.ics.hyracks.control.cc.scheduler.PartitionConstraintSolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;

public class ActivityClusterPlanner {
    private static final Logger LOGGER = Logger.getLogger(ActivityClusterPlanner.class.getName());
    private final JobScheduler scheduler;
    private final Map<PartitionId, TaskCluster> partitionProducingTaskClusterMap;

    public ActivityClusterPlanner(JobScheduler newJobScheduler) {
        this.scheduler = newJobScheduler;
        this.partitionProducingTaskClusterMap = new HashMap<PartitionId, TaskCluster>();
    }

    public ActivityClusterPlan planActivityCluster(ActivityCluster ac) throws HyracksException {
        JobRun jobRun = this.scheduler.getJobRun();
        Map<ActivityId, ActivityPartitionDetails> pcMap = this.computePartitionCounts(ac);
        Map<ActivityId, ActivityPlan> activityPlanMap = this.buildActivityPlanMap(ac, jobRun, pcMap);
        this.assignConnectorPolicy(ac, activityPlanMap);
        TaskCluster[] taskClusters = this.computeTaskClusters(ac, jobRun, activityPlanMap);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Plan for " + ac);
            LOGGER.info("Built " + taskClusters.length + " Task Clusters");
            for (TaskCluster tc : taskClusters) {
                LOGGER.info("Tasks: " + Arrays.toString(tc.getTasks()));
            }
        }
        return new ActivityClusterPlan(taskClusters, activityPlanMap);
    }

    private Map<ActivityId, ActivityPlan> buildActivityPlanMap(ActivityCluster ac, JobRun jobRun, Map<ActivityId, ActivityPartitionDetails> pcMap) {
        HashMap<ActivityId, ActivityPlan> activityPlanMap = new HashMap<ActivityId, ActivityPlan>();
        HashSet<ActivityId> depAnIds = new HashSet<ActivityId>();
        for (ActivityId anId : ac.getActivityMap().keySet()) {
            depAnIds.clear();
            this.getDependencyActivityIds(depAnIds, anId, ac);
            ActivityPartitionDetails apd = pcMap.get(anId);
            Task[] tasks = new Task[apd.getPartitionCount()];
            ActivityPlan activityPlan = new ActivityPlan(apd);
            for (int i = 0; i < tasks.length; ++i) {
                TaskId tid = new TaskId(anId, i);
                tasks[i] = new Task(tid, activityPlan);
                for (ActivityId danId : depAnIds) {
                    ActivityCluster dAC = (ActivityCluster)ac.getActivityClusterGraph().getActivityMap().get(danId);
                    ActivityClusterPlan dACP = jobRun.getActivityClusterPlanMap().get(dAC.getId());
                    assert (dACP != null) : "IllegalStateEncountered: Dependent AC is being planned without a plan for dependency AC: Encountered no plan for ActivityID " + danId;
                    Task[] dATasks = dACP.getActivityPlanMap().get(danId).getTasks();
                    assert (dATasks != null) : "IllegalStateEncountered: Dependent AC is being planned without a plan for dependency AC: Encountered no plan for ActivityID " + danId;
                    assert (dATasks.length == tasks.length) : "Dependency activity partitioned differently from dependent: " + dATasks.length + " != " + tasks.length;
                    Task dTask = dATasks[i];
                    TaskId dTaskId = dTask.getTaskId();
                    tasks[i].getDependencies().add(dTaskId);
                    dTask.getDependents().add(tid);
                }
            }
            activityPlan.setTasks(tasks);
            activityPlanMap.put(anId, activityPlan);
        }
        return activityPlanMap;
    }

    private TaskCluster[] computeTaskClusters(ActivityCluster ac, JobRun jobRun, Map<ActivityId, ActivityPlan> activityPlanMap) {
        TaskCluster[] taskClusters;
        Set<ActivityId> activities = ac.getActivityMap().keySet();
        Map<TaskId, List<Pair<TaskId, ConnectorDescriptorId>>> taskConnectivity = this.computeTaskConnectivity(jobRun, activityPlanMap, activities);
        for (TaskCluster tc : taskClusters = ac.getActivityClusterGraph().isUseConnectorPolicyForScheduling() ? this.buildConnectorPolicyAwareTaskClusters(ac, activityPlanMap, taskConnectivity) : this.buildConnectorPolicyUnawareTaskClusters(ac, activityPlanMap)) {
            Set<TaskCluster> tcDependencyTaskClusters = tc.getDependencyTaskClusters();
            for (Task ts : tc.getTasks()) {
                TaskId tid = ts.getTaskId();
                List<Pair<TaskId, ConnectorDescriptorId>> cInfoList = taskConnectivity.get(tid);
                if (cInfoList != null) {
                    for (Pair<TaskId, ConnectorDescriptorId> p : cInfoList) {
                        Task targetTS = activityPlanMap.get(((TaskId)p.getLeft()).getActivityId()).getTasks()[((TaskId)p.getLeft()).getPartition()];
                        TaskCluster targetTC = targetTS.getTaskCluster();
                        if (targetTC == tc) continue;
                        ConnectorDescriptorId cdId = (ConnectorDescriptorId)p.getRight();
                        PartitionId pid = new PartitionId(jobRun.getJobId(), cdId, tid.getPartition(), ((TaskId)p.getLeft()).getPartition());
                        tc.getProducedPartitions().add(pid);
                        targetTC.getRequiredPartitions().add(pid);
                        this.partitionProducingTaskClusterMap.put(pid, tc);
                    }
                }
                for (TaskId dTid : ts.getDependencies()) {
                    TaskCluster dTC = this.getTaskCluster(dTid);
                    dTC.getDependentTaskClusters().add(tc);
                    tcDependencyTaskClusters.add(dTC);
                }
            }
        }
        return taskClusters;
    }

    private TaskCluster[] buildConnectorPolicyUnawareTaskClusters(ActivityCluster ac, Map<ActivityId, ActivityPlan> activityPlanMap) {
        ArrayList<Task> taskStates = new ArrayList<Task>();
        for (ActivityId anId : ac.getActivityMap().keySet()) {
            Task[] tasks;
            ActivityPlan ap = activityPlanMap.get(anId);
            for (Task t : tasks = ap.getTasks()) {
                taskStates.add(t);
            }
        }
        TaskCluster tc = new TaskCluster(new TaskClusterId(ac.getId(), 0), ac, taskStates.toArray(new Task[taskStates.size()]));
        for (Task t : tc.getTasks()) {
            t.setTaskCluster(tc);
        }
        return new TaskCluster[]{tc};
    }

    private Map<TaskId, List<Pair<TaskId, ConnectorDescriptorId>>> computeTaskConnectivity(JobRun jobRun, Map<ActivityId, ActivityPlan> activityPlanMap, Set<ActivityId> activities) {
        HashMap<TaskId, List<Pair<TaskId, ConnectorDescriptorId>>> taskConnectivity = new HashMap<TaskId, List<Pair<TaskId, ConnectorDescriptorId>>>();
        ActivityClusterGraph acg = jobRun.getActivityClusterGraph();
        BitSet targetBitmap = new BitSet();
        for (ActivityId ac1 : activities) {
            ActivityCluster ac = (ActivityCluster)acg.getActivityMap().get(ac1);
            Task[] ac1TaskStates = activityPlanMap.get(ac1).getTasks();
            int nProducers = ac1TaskStates.length;
            List outputConns = (List)ac.getActivityOutputMap().get(ac1);
            if (outputConns == null) continue;
            for (IConnectorDescriptor c : outputConns) {
                ConnectorDescriptorId cdId = c.getConnectorId();
                ActivityId ac2 = ac.getConsumerActivity(cdId);
                Task[] ac2TaskStates = activityPlanMap.get(ac2).getTasks();
                int nConsumers = ac2TaskStates.length;
                if (c.allProducersToAllConsumers()) {
                    ArrayList<Pair> cInfoList = new ArrayList<Pair>();
                    for (int j = 0; j < nConsumers; ++j) {
                        TaskId targetTID = ac2TaskStates[j].getTaskId();
                        cInfoList.add(Pair.of((Object)targetTID, (Object)cdId));
                    }
                    for (int i = 0; i < nProducers; ++i) {
                        taskConnectivity.put(ac1TaskStates[i].getTaskId(), cInfoList);
                    }
                    continue;
                }
                for (int i = 0; i < nProducers; ++i) {
                    c.indicateTargetPartitions(nProducers, nConsumers, i, targetBitmap);
                    ArrayList<Pair> cInfoList = (ArrayList<Pair>)taskConnectivity.get(ac1TaskStates[i].getTaskId());
                    if (cInfoList == null) {
                        cInfoList = new ArrayList<Pair>();
                        taskConnectivity.put(ac1TaskStates[i].getTaskId(), cInfoList);
                    }
                    int j = targetBitmap.nextSetBit(0);
                    while (j >= 0) {
                        TaskId targetTID = ac2TaskStates[j].getTaskId();
                        cInfoList.add(Pair.of((Object)targetTID, (Object)cdId));
                        j = targetBitmap.nextSetBit(j + 1);
                    }
                }
            }
        }
        return taskConnectivity;
    }

    private TaskCluster[] buildConnectorPolicyAwareTaskClusters(ActivityCluster ac, Map<ActivityId, ActivityPlan> activityPlanMap, Map<TaskId, List<Pair<TaskId, ConnectorDescriptorId>>> taskConnectivity) {
        HashMap taskClusterMap = new HashMap();
        for (ActivityId anId : ac.getActivityMap().keySet()) {
            Task[] tasks;
            ActivityPlan ap = activityPlanMap.get(anId);
            for (Task t : tasks = ap.getTasks()) {
                HashSet<TaskId> cluster = new HashSet<TaskId>();
                TaskId tid = t.getTaskId();
                cluster.add(tid);
                taskClusterMap.put(tid, cluster);
            }
        }
        JobRun jobRun = this.scheduler.getJobRun();
        Map<ConnectorDescriptorId, IConnectorPolicy> connectorPolicies = jobRun.getConnectorPolicyMap();
        for (Map.Entry<TaskId, List<Pair<TaskId, ConnectorDescriptorId>>> e : taskConnectivity.entrySet()) {
            Set cluster = (Set)taskClusterMap.get(e.getKey());
            for (Pair<TaskId, ConnectorDescriptorId> p : e.getValue()) {
                IConnectorPolicy cPolicy = connectorPolicies.get(p.getRight());
                if (!cPolicy.requiresProducerConsumerCoscheduling()) continue;
                cluster.add(p.getLeft());
            }
        }
        int counter = 0;
        TaskId[] ordinalList = new TaskId[taskClusterMap.size()];
        HashMap<TaskId, Integer> ordinalMap = new HashMap<TaskId, Integer>();
        Iterator i$ = taskClusterMap.keySet().iterator();
        while (i$.hasNext()) {
            TaskId tid;
            ordinalList[counter] = tid = (TaskId)i$.next();
            ordinalMap.put(tid, counter);
            ++counter;
        }
        int n = ordinalList.length;
        BitSet[] paths = new BitSet[n];
        for (Map.Entry e : taskClusterMap.entrySet()) {
            int i = (Integer)ordinalMap.get(e.getKey());
            BitSet bsi = paths[i];
            if (bsi == null) {
                paths[i] = bsi = new BitSet(n);
            }
            for (TaskId ttid : (Set)e.getValue()) {
                int j = (Integer)ordinalMap.get(ttid);
                paths[i].set(j);
                BitSet bsj = paths[j];
                if (bsj == null) {
                    paths[j] = bsj = new BitSet(n);
                }
                bsj.set(i);
            }
        }
        for (int k = 0; k < n; ++k) {
            int i = paths[k].nextSetBit(0);
            while (i >= 0) {
                int j = paths[i].nextClearBit(0);
                while (j < n && j >= 0) {
                    paths[i].set(j, paths[k].get(j));
                    paths[j].set(i, paths[i].get(j));
                    j = paths[i].nextClearBit(j + 1);
                }
                i = paths[k].nextSetBit(i + 1);
            }
        }
        BitSet pending = new BitSet(n);
        pending.set(0, n);
        ArrayList clusters = new ArrayList();
        int i = pending.nextSetBit(0);
        while (i >= 0) {
            ArrayList<TaskId> cluster = new ArrayList<TaskId>();
            int n2 = paths[i].nextSetBit(0);
            while (n2 >= 0) {
                cluster.add(ordinalList[n2]);
                pending.clear(n2);
                n2 = paths[i].nextSetBit(n2 + 1);
            }
            clusters.add(cluster);
            i = pending.nextSetBit(i);
        }
        ArrayList<TaskCluster> tcSet = new ArrayList<TaskCluster>();
        counter = 0;
        for (List list : clusters) {
            ArrayList<Task> taskStates = new ArrayList<Task>();
            for (TaskId tid : list) {
                taskStates.add(activityPlanMap.get(tid.getActivityId()).getTasks()[tid.getPartition()]);
            }
            TaskCluster tc = new TaskCluster(new TaskClusterId(ac.getId(), counter++), ac, taskStates.toArray(new Task[taskStates.size()]));
            tcSet.add(tc);
            for (TaskId tid : list) {
                activityPlanMap.get(tid.getActivityId()).getTasks()[tid.getPartition()].setTaskCluster(tc);
            }
        }
        TaskCluster[] taskClusters = tcSet.toArray(new TaskCluster[tcSet.size()]);
        return taskClusters;
    }

    private TaskCluster getTaskCluster(TaskId tid) {
        JobRun run = this.scheduler.getJobRun();
        ActivityCluster ac = (ActivityCluster)run.getActivityClusterGraph().getActivityMap().get(tid.getActivityId());
        ActivityClusterPlan acp = run.getActivityClusterPlanMap().get(ac.getId());
        Task[] tasks = acp.getActivityPlanMap().get(tid.getActivityId()).getTasks();
        Task task = tasks[tid.getPartition()];
        assert (task.getTaskId().equals((Object)tid));
        return task.getTaskCluster();
    }

    private void getDependencyActivityIds(Set<ActivityId> depAnIds, ActivityId anId, ActivityCluster ac) {
        Set blockers = (Set)ac.getBlocked2BlockerMap().get(anId);
        if (blockers != null) {
            depAnIds.addAll(blockers);
        }
    }

    private void assignConnectorPolicy(ActivityCluster ac, Map<ActivityId, ActivityPlan> taskMap) {
        HashMap<ConnectorDescriptorId, IConnectorPolicy> cPolicyMap = new HashMap<ConnectorDescriptorId, IConnectorPolicy>();
        Set activities = ac.getActivityMap().keySet();
        BitSet targetBitmap = new BitSet();
        for (ActivityId a1 : activities) {
            Task[] ac1TaskStates = taskMap.get(a1).getTasks();
            int nProducers = ac1TaskStates.length;
            List outputConns = (List)ac.getActivityOutputMap().get(a1);
            if (outputConns == null) continue;
            for (IConnectorDescriptor c : outputConns) {
                int i;
                ConnectorDescriptorId cdId = c.getConnectorId();
                ActivityId a2 = ac.getConsumerActivity(cdId);
                Task[] ac2TaskStates = taskMap.get(a2).getTasks();
                int nConsumers = ac2TaskStates.length;
                int[] fanouts = new int[nProducers];
                if (c.allProducersToAllConsumers()) {
                    for (i = 0; i < nProducers; ++i) {
                        fanouts[i] = nConsumers;
                    }
                } else {
                    for (i = 0; i < nProducers; ++i) {
                        c.indicateTargetPartitions(nProducers, nConsumers, i, targetBitmap);
                        fanouts[i] = targetBitmap.cardinality();
                    }
                }
                IConnectorPolicy cp = this.assignConnectorPolicy(ac, c, nProducers, nConsumers, fanouts);
                cPolicyMap.put(cdId, cp);
            }
        }
        this.scheduler.getJobRun().getConnectorPolicyMap().putAll(cPolicyMap);
    }

    private IConnectorPolicy assignConnectorPolicy(ActivityCluster ac, IConnectorDescriptor c, int nProducers, int nConsumers, int[] fanouts) {
        IConnectorPolicyAssignmentPolicy cpap = ac.getConnectorPolicyAssignmentPolicy();
        if (cpap != null) {
            return cpap.getConnectorPolicyAssignment(c, nProducers, nConsumers, fanouts);
        }
        cpap = ac.getActivityClusterGraph().getConnectorPolicyAssignmentPolicy();
        if (cpap != null) {
            return cpap.getConnectorPolicyAssignment(c, nProducers, nConsumers, fanouts);
        }
        return new PipeliningConnectorPolicy();
    }

    private Map<ActivityId, ActivityPartitionDetails> computePartitionCounts(ActivityCluster ac) throws HyracksException {
        int nParts;
        PartitionConstraintSolver solver = this.scheduler.getSolver();
        HashSet<LValueConstraintExpression> lValues = new HashSet<LValueConstraintExpression>();
        for (ActivityId anId : ac.getActivityMap().keySet()) {
            lValues.add((LValueConstraintExpression)new PartitionCountExpression(anId.getOperatorDescriptorId()));
        }
        solver.solve(lValues);
        HashMap<OperatorDescriptorId, Integer> nPartMap = new HashMap<OperatorDescriptorId, Integer>();
        for (LValueConstraintExpression lv : lValues) {
            Object value = solver.getValue(lv);
            if (value == null) {
                throw new HyracksException("No value found for " + lv);
            }
            if (!(value instanceof Number)) {
                throw new HyracksException("Unexpected type of value bound to " + lv + ": " + value.getClass() + "(" + value + ")");
            }
            nParts = ((Number)value).intValue();
            if (nParts <= 0) {
                throw new HyracksException("Unsatisfiable number of partitions for " + lv + ": " + nParts);
            }
            nPartMap.put(((PartitionCountExpression)lv).getOperatorDescriptorId(), nParts);
        }
        HashMap<ActivityId, ActivityPartitionDetails> activityPartsMap = new HashMap<ActivityId, ActivityPartitionDetails>();
        for (ActivityId anId : ac.getActivityMap().keySet()) {
            nParts = (Integer)nPartMap.get(anId.getOperatorDescriptorId());
            int[] nInputPartitions = null;
            List inputs = (List)ac.getActivityInputMap().get(anId);
            if (inputs != null) {
                nInputPartitions = new int[inputs.size()];
                for (int i = 0; i < nInputPartitions.length; ++i) {
                    ConnectorDescriptorId cdId = ((IConnectorDescriptor)inputs.get(i)).getConnectorId();
                    ActivityId aid = ac.getProducerActivity(cdId);
                    Integer nPartInt = (Integer)nPartMap.get(aid.getOperatorDescriptorId());
                    nInputPartitions[i] = nPartInt;
                }
            }
            int[] nOutputPartitions = null;
            List outputs = (List)ac.getActivityOutputMap().get(anId);
            if (outputs != null) {
                nOutputPartitions = new int[outputs.size()];
                for (int i = 0; i < nOutputPartitions.length; ++i) {
                    ConnectorDescriptorId cdId = ((IConnectorDescriptor)outputs.get(i)).getConnectorId();
                    ActivityId aid = ac.getConsumerActivity(cdId);
                    Integer nPartInt = (Integer)nPartMap.get(aid.getOperatorDescriptorId());
                    nOutputPartitions[i] = nPartInt;
                }
            }
            ActivityPartitionDetails apd = new ActivityPartitionDetails(nParts, nInputPartitions, nOutputPartitions);
            activityPartsMap.put(anId, apd);
        }
        return activityPartsMap;
    }

    public Map<? extends PartitionId, ? extends TaskCluster> getPartitionProducingTaskClusterMap() {
        return this.partitionProducingTaskClusterMap;
    }
}

