/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.job;

import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.ConnectorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.OperatorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.connectors.IConnectorPolicy;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.ActivityCluster;
import edu.uci.ics.hyracks.api.job.ActivityClusterGraph;
import edu.uci.ics.hyracks.api.job.ActivityClusterId;
import edu.uci.ics.hyracks.api.job.IActivityClusterGraphGenerator;
import edu.uci.ics.hyracks.api.job.JobFlag;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.job.JobStatus;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.job.ActivityClusterPlan;
import edu.uci.ics.hyracks.control.cc.job.ActivityPlan;
import edu.uci.ics.hyracks.control.cc.job.IJobStatusConditionVariable;
import edu.uci.ics.hyracks.control.cc.job.Task;
import edu.uci.ics.hyracks.control.cc.job.TaskAttempt;
import edu.uci.ics.hyracks.control.cc.job.TaskCluster;
import edu.uci.ics.hyracks.control.cc.job.TaskClusterAttempt;
import edu.uci.ics.hyracks.control.cc.partitions.PartitionMatchMaker;
import edu.uci.ics.hyracks.control.cc.scheduler.ActivityPartitionDetails;
import edu.uci.ics.hyracks.control.cc.scheduler.JobScheduler;
import edu.uci.ics.hyracks.control.common.job.profiling.om.JobProfile;
import edu.uci.ics.hyracks.control.common.utils.ExceptionUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JobRun
implements IJobStatusConditionVariable {
    private final DeploymentId deploymentId;
    private final JobId jobId;
    private final IActivityClusterGraphGenerator acgg;
    private final ActivityClusterGraph acg;
    private final JobScheduler scheduler;
    private final EnumSet<JobFlag> jobFlags;
    private final Map<ActivityClusterId, ActivityClusterPlan> activityClusterPlanMap;
    private final PartitionMatchMaker pmm;
    private final Set<String> participatingNodeIds;
    private final Set<String> cleanupPendingNodeIds;
    private final JobProfile profile;
    private final Map<ConnectorDescriptorId, IConnectorPolicy> connectorPolicyMap;
    private long createTime;
    private long startTime;
    private long endTime;
    private JobStatus status;
    private List<Exception> exceptions;
    private JobStatus pendingStatus;
    private List<Exception> pendingExceptions;
    private Map<OperatorDescriptorId, Map<Integer, String>> operatorLocations;

    public JobRun(ClusterControllerService ccs, DeploymentId deploymentId, JobId jobId, IActivityClusterGraphGenerator acgg, EnumSet<JobFlag> jobFlags) {
        this.deploymentId = deploymentId;
        this.jobId = jobId;
        this.acgg = acgg;
        this.acg = acgg.initialize();
        this.scheduler = new JobScheduler(ccs, this, acgg.getConstraints());
        this.jobFlags = jobFlags;
        this.activityClusterPlanMap = new HashMap<ActivityClusterId, ActivityClusterPlan>();
        this.pmm = new PartitionMatchMaker();
        this.participatingNodeIds = new HashSet<String>();
        this.cleanupPendingNodeIds = new HashSet<String>();
        this.profile = new JobProfile(jobId);
        this.connectorPolicyMap = new HashMap<ConnectorDescriptorId, IConnectorPolicy>();
        this.operatorLocations = new HashMap<OperatorDescriptorId, Map<Integer, String>>();
    }

    public DeploymentId getDeploymentId() {
        return this.deploymentId;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public ActivityClusterGraph getActivityClusterGraph() {
        return this.acg;
    }

    public EnumSet<JobFlag> getFlags() {
        return this.jobFlags;
    }

    public Map<ActivityClusterId, ActivityClusterPlan> getActivityClusterPlanMap() {
        return this.activityClusterPlanMap;
    }

    public PartitionMatchMaker getPartitionMatchMaker() {
        return this.pmm;
    }

    public synchronized void setStatus(JobStatus status, List<Exception> exceptions) {
        this.status = status;
        this.exceptions = exceptions;
        this.notifyAll();
    }

    public synchronized JobStatus getStatus() {
        return this.status;
    }

    public synchronized List<Exception> getExceptions() {
        return this.exceptions;
    }

    public void setPendingStatus(JobStatus status, List<Exception> exceptions) {
        this.pendingStatus = status;
        this.pendingExceptions = exceptions;
    }

    public JobStatus getPendingStatus() {
        return this.pendingStatus;
    }

    public synchronized List<Exception> getPendingExceptions() {
        return this.pendingExceptions;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void registerOperatorLocation(OperatorDescriptorId op, int partition, String location) {
        Map<Integer, String> locations = this.operatorLocations.get(op);
        if (locations == null) {
            locations = new HashMap<Integer, String>();
            this.operatorLocations.put(op, locations);
        }
        locations.put(partition, location);
    }

    @Override
    public synchronized void waitForCompletion() throws Exception {
        while (this.status != JobStatus.TERMINATED && this.status != JobStatus.FAILURE) {
            this.wait();
        }
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Job failed on account of:\n");
            for (Exception e : this.exceptions) {
                buffer.append(e.getMessage()).append('\n');
            }
            HyracksException he = new HyracksException(buffer.toString(), (Throwable)this.exceptions.get(0));
            for (int i = 1; i < this.exceptions.size(); ++i) {
                he.addSuppressed((Throwable)this.exceptions.get(i));
            }
            throw he;
        }
    }

    public Set<String> getParticipatingNodeIds() {
        return this.participatingNodeIds;
    }

    public Set<String> getCleanupPendingNodeIds() {
        return this.cleanupPendingNodeIds;
    }

    public JobProfile getJobProfile() {
        return this.profile;
    }

    public JobScheduler getScheduler() {
        return this.scheduler;
    }

    public Map<ConnectorDescriptorId, IConnectorPolicy> getConnectorPolicyMap() {
        return this.connectorPolicyMap;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject result = new JSONObject();
        result.put("job-id", (Object)this.jobId.toString());
        result.put("status", (Object)this.getStatus());
        result.put("create-time", this.getCreateTime());
        result.put("start-time", this.getCreateTime());
        result.put("end-time", this.getCreateTime());
        JSONArray aClusters = new JSONArray();
        for (ActivityCluster ac : this.acg.getActivityClusterMap().values()) {
            JSONObject acJSON = new JSONObject();
            acJSON.put("activity-cluster-id", (Object)String.valueOf(ac.getId()));
            JSONArray activitiesJSON = new JSONArray();
            for (ActivityId aid : ac.getActivityMap().keySet()) {
                activitiesJSON.put((Object)aid);
            }
            acJSON.put("activities", (Object)activitiesJSON);
            JSONArray dependenciesJSON = new JSONArray();
            for (ActivityCluster dependency : ac.getDependencies()) {
                dependenciesJSON.put((Object)String.valueOf(dependency.getId()));
            }
            acJSON.put("dependencies", (Object)dependenciesJSON);
            ActivityClusterPlan acp = this.activityClusterPlanMap.get(ac.getId());
            if (acp == null) {
                acJSON.put("plan", (Object)null);
            } else {
                JSONObject planJSON = new JSONObject();
                JSONArray acTasks = new JSONArray();
                for (Map.Entry<ActivityId, ActivityPlan> e : acp.getActivityPlanMap().entrySet()) {
                    ActivityPlan acPlan = e.getValue();
                    JSONObject entry = new JSONObject();
                    entry.put("activity-id", (Object)e.getKey().toString());
                    ActivityPartitionDetails apd = acPlan.getActivityPartitionDetails();
                    entry.put("partition-count", apd.getPartitionCount());
                    JSONArray inPartCountsJSON = new JSONArray();
                    int[] inPartCounts = apd.getInputPartitionCounts();
                    if (inPartCounts != null) {
                        for (int i : inPartCounts) {
                            inPartCountsJSON.put(i);
                        }
                    }
                    entry.put("input-partition-counts", (Object)inPartCountsJSON);
                    JSONArray jSONArray = new JSONArray();
                    int[] outPartCounts = apd.getOutputPartitionCounts();
                    if (outPartCounts != null) {
                        for (int o : outPartCounts) {
                            jSONArray.put(o);
                        }
                    }
                    entry.put("output-partition-counts", (Object)jSONArray);
                    JSONArray tasks = new JSONArray();
                    for (Task t : acPlan.getTasks()) {
                        JSONObject task = new JSONObject();
                        task.put("task-id", (Object)t.getTaskId().toString());
                        JSONArray dependentTasksJSON = new JSONArray();
                        for (TaskId dependent : t.getDependents()) {
                            dependentTasksJSON.put((Object)dependent.toString());
                        }
                        task.put("dependents", (Object)dependentTasksJSON);
                        JSONArray dependencyTasksJSON = new JSONArray();
                        for (TaskId dependency : t.getDependencies()) {
                            dependencyTasksJSON.put((Object)dependency.toString());
                        }
                        task.put("dependencies", (Object)dependencyTasksJSON);
                        tasks.put((Object)task);
                    }
                    entry.put("tasks", (Object)tasks);
                    acTasks.put((Object)entry);
                }
                planJSON.put("activities", (Object)acTasks);
                JSONArray tClusters = new JSONArray();
                for (TaskCluster tc : acp.getTaskClusters()) {
                    JSONObject c = new JSONObject();
                    c.put("task-cluster-id", (Object)String.valueOf(tc.getTaskClusterId()));
                    JSONArray tasks = new JSONArray();
                    for (Task t : tc.getTasks()) {
                        tasks.put((Object)t.getTaskId().toString());
                    }
                    c.put("tasks", (Object)tasks);
                    JSONArray jSONArray = new JSONArray();
                    for (PartitionId p : tc.getProducedPartitions()) {
                        jSONArray.put((Object)p.toString());
                    }
                    c.put("produced-partitions", (Object)jSONArray);
                    JSONArray reqdParts = new JSONArray();
                    for (PartitionId p : tc.getRequiredPartitions()) {
                        reqdParts.put((Object)p.toString());
                    }
                    c.put("required-partitions", (Object)reqdParts);
                    JSONArray attempts = new JSONArray();
                    List<TaskClusterAttempt> tcAttempts = tc.getAttempts();
                    if (tcAttempts != null) {
                        for (TaskClusterAttempt tca : tcAttempts) {
                            JSONObject attempt = new JSONObject();
                            attempt.put("attempt", tca.getAttempt());
                            attempt.put("status", (Object)tca.getStatus());
                            attempt.put("start-time", tca.getStartTime());
                            attempt.put("end-time", tca.getEndTime());
                            JSONArray taskAttempts = new JSONArray();
                            for (TaskAttempt ta : tca.getTaskAttempts().values()) {
                                JSONObject taskAttempt = new JSONObject();
                                taskAttempt.put("task-id", (Object)ta.getTaskAttemptId().getTaskId());
                                taskAttempt.put("task-attempt-id", (Object)ta.getTaskAttemptId());
                                taskAttempt.put("status", (Object)ta.getStatus());
                                taskAttempt.put("node-id", (Object)ta.getNodeId());
                                taskAttempt.put("start-time", ta.getStartTime());
                                taskAttempt.put("end-time", ta.getEndTime());
                                List<Exception> exceptions = ta.getExceptions();
                                if (exceptions != null && !exceptions.isEmpty()) {
                                    List filteredExceptions = ExceptionUtils.getActualExceptions(exceptions);
                                    for (Exception exception : filteredExceptions) {
                                        StringWriter exceptionWriter = new StringWriter();
                                        exception.printStackTrace(new PrintWriter(exceptionWriter));
                                        taskAttempt.put("failure-details", (Object)exceptionWriter.toString());
                                    }
                                }
                                taskAttempts.put((Object)taskAttempt);
                            }
                            attempt.put("task-attempts", (Object)taskAttempts);
                            attempts.put((Object)attempt);
                        }
                    }
                    c.put("attempts", (Object)attempts);
                    tClusters.put((Object)c);
                }
                planJSON.put("task-clusters", (Object)tClusters);
                acJSON.put("plan", (Object)planJSON);
            }
            aClusters.put((Object)acJSON);
        }
        result.put("activity-clusters", (Object)aClusters);
        result.put("profile", (Object)this.profile.toJSON());
        return result;
    }

    public Map<OperatorDescriptorId, Map<Integer, String>> getOperatorLocations() {
        return this.operatorLocations;
    }
}

