/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.dataset;

import edu.uci.ics.hyracks.api.comm.NetworkAddress;
import edu.uci.ics.hyracks.api.dataset.DatasetDirectoryRecord;
import edu.uci.ics.hyracks.api.dataset.DatasetJobRecord;
import edu.uci.ics.hyracks.api.dataset.IDatasetManager;
import edu.uci.ics.hyracks.api.dataset.IDatasetStateRecord;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.dataset.ResultSetMetaData;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.dataset.IDatasetDirectoryService;
import edu.uci.ics.hyracks.control.common.dataset.ResultStateSweeper;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class DatasetDirectoryService
implements IDatasetDirectoryService {
    private final long resultTTL;
    private final long resultSweepThreshold;
    private final Map<JobId, IDatasetStateRecord> jobResultLocations;

    public DatasetDirectoryService(long resultTTL, long resultSweepThreshold) {
        this.resultTTL = resultTTL;
        this.resultSweepThreshold = resultSweepThreshold;
        this.jobResultLocations = new LinkedHashMap<JobId, IDatasetStateRecord>();
    }

    @Override
    public void init(ExecutorService executor) {
        executor.execute((Runnable)new ResultStateSweeper((IDatasetManager)this, this.resultTTL, this.resultSweepThreshold));
    }

    public synchronized void notifyJobCreation(JobId jobId, IActivityClusterGraphGeneratorFactory acggf) throws HyracksException {
        DatasetJobRecord djr = (DatasetJobRecord)this.jobResultLocations.get(jobId);
        if (djr == null) {
            djr = new DatasetJobRecord();
            this.jobResultLocations.put(jobId, (IDatasetStateRecord)djr);
        }
    }

    public void notifyJobStart(JobId jobId) throws HyracksException {
    }

    public void notifyJobFinish(JobId jobId) throws HyracksException {
    }

    @Override
    public synchronized void registerResultPartitionLocation(JobId jobId, ResultSetId rsId, boolean orderedResult, int partition, int nPartitions, NetworkAddress networkAddress) {
        DatasetDirectoryRecord[] records;
        DatasetJobRecord djr = (DatasetJobRecord)this.jobResultLocations.get(jobId);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)djr.get((Object)rsId);
        if (resultSetMetaData == null) {
            resultSetMetaData = new ResultSetMetaData(orderedResult, new DatasetDirectoryRecord[nPartitions]);
            djr.put((Object)rsId, (Object)resultSetMetaData);
        }
        if ((records = resultSetMetaData.getRecords())[partition] == null) {
            records[partition] = new DatasetDirectoryRecord();
        }
        records[partition].setNetworkAddress(networkAddress);
        records[partition].start();
        this.notifyAll();
    }

    @Override
    public synchronized void reportResultPartitionWriteCompletion(JobId jobId, ResultSetId rsId, int partition) {
        int successCount = 0;
        DatasetJobRecord djr = (DatasetJobRecord)this.jobResultLocations.get(jobId);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)djr.get((Object)rsId);
        DatasetDirectoryRecord[] records = resultSetMetaData.getRecords();
        records[partition].writeEOS();
        for (DatasetDirectoryRecord record : records) {
            if (record == null || record.getStatus() != DatasetDirectoryRecord.Status.SUCCESS) continue;
            ++successCount;
        }
        if (successCount == records.length) {
            djr.success();
        }
        this.notifyAll();
    }

    @Override
    public synchronized void reportResultPartitionFailure(JobId jobId, ResultSetId rsId, int partition) {
        DatasetJobRecord djr = (DatasetJobRecord)this.jobResultLocations.get(jobId);
        if (djr != null) {
            djr.fail();
        }
        this.notifyAll();
    }

    @Override
    public synchronized void reportJobFailure(JobId jobId, List<Exception> exceptions) {
        DatasetJobRecord djr = (DatasetJobRecord)this.jobResultLocations.get(jobId);
        if (djr != null) {
            djr.fail(exceptions);
        }
        this.notifyAll();
    }

    @Override
    public synchronized DatasetJobRecord.Status getResultStatus(JobId jobId, ResultSetId rsId) throws HyracksDataException {
        DatasetJobRecord djr;
        while ((djr = (DatasetJobRecord)this.jobResultLocations.get(jobId)) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        return djr.getStatus();
    }

    public Map<JobId, IDatasetStateRecord> getStateMap() {
        return this.jobResultLocations;
    }

    public void deinitState(JobId jobId) {
        this.jobResultLocations.remove(this.jobResultLocations.get(jobId));
    }

    @Override
    public synchronized DatasetDirectoryRecord[] getResultPartitionLocations(JobId jobId, ResultSetId rsId, DatasetDirectoryRecord[] knownRecords) throws HyracksDataException {
        DatasetDirectoryRecord[] newRecords;
        while ((newRecords = this.updatedRecords(jobId, rsId, knownRecords)) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        return newRecords;
    }

    private DatasetDirectoryRecord[] updatedRecords(JobId jobId, ResultSetId rsId, DatasetDirectoryRecord[] knownRecords) throws HyracksDataException {
        DatasetJobRecord djr = (DatasetJobRecord)this.jobResultLocations.get(jobId);
        if (djr == null) {
            throw new HyracksDataException("Requested JobId " + jobId + " doesn't exist");
        }
        if (djr.getStatus() == DatasetJobRecord.Status.FAILED) {
            List caughtExceptions = djr.getExceptions();
            if (caughtExceptions == null) {
                throw new HyracksDataException("Job failed.");
            }
            throw new HyracksDataException((Throwable)caughtExceptions.get(caughtExceptions.size() - 1));
        }
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)djr.get((Object)rsId);
        if (resultSetMetaData == null || resultSetMetaData.getRecords() == null) {
            return null;
        }
        boolean ordered = resultSetMetaData.getOrderedResult();
        Object[] records = resultSetMetaData.getRecords();
        if (ordered) {
            int i = 0;
            for (i = 0; i < records.length; ++i) {
                if (knownRecords == null) {
                    if (records[0] != null) {
                        knownRecords = new DatasetDirectoryRecord[records.length];
                        knownRecords[0] = records[0];
                        return knownRecords;
                    }
                    return null;
                }
                if (knownRecords[i] != null) continue;
                if ((i == 0 || knownRecords[i - 1].hasReachedReadEOS()) && records[i] != null) {
                    knownRecords[i] = records[i];
                    return knownRecords;
                }
                return null;
            }
        } else if (!Arrays.equals(records, knownRecords)) {
            return records;
        }
        return null;
    }
}

