/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.application;

import edu.uci.ics.hyracks.api.application.ICCApplicationContext;
import edu.uci.ics.hyracks.api.application.IClusterLifecycleListener;
import edu.uci.ics.hyracks.api.context.ICCContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import edu.uci.ics.hyracks.api.job.IJobLifecycleListener;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.common.application.ApplicationContext;
import edu.uci.ics.hyracks.control.common.context.ServerContext;
import edu.uci.ics.hyracks.control.common.work.IResultCallback;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CCApplicationContext
extends ApplicationContext
implements ICCApplicationContext {
    private final ICCContext ccContext;
    protected final Set<String> initPendingNodeIds;
    protected final Set<String> deinitPendingNodeIds;
    protected IResultCallback<Object> initializationCallback;
    protected IResultCallback<Object> deinitializationCallback;
    private List<IJobLifecycleListener> jobLifecycleListeners;
    private List<IClusterLifecycleListener> clusterLifecycleListeners;

    public CCApplicationContext(ServerContext serverCtx, ICCContext ccContext) throws IOException {
        super(serverCtx);
        this.ccContext = ccContext;
        this.initPendingNodeIds = new HashSet<String>();
        this.deinitPendingNodeIds = new HashSet<String>();
        this.jobLifecycleListeners = new ArrayList<IJobLifecycleListener>();
        this.clusterLifecycleListeners = new ArrayList<IClusterLifecycleListener>();
    }

    public ICCContext getCCContext() {
        return this.ccContext;
    }

    public void setDistributedState(Serializable state) {
        this.distributedState = state;
    }

    public void addJobLifecycleListener(IJobLifecycleListener jobLifecycleListener) {
        this.jobLifecycleListeners.add(jobLifecycleListener);
    }

    public synchronized void notifyJobStart(JobId jobId) throws HyracksException {
        for (IJobLifecycleListener l : this.jobLifecycleListeners) {
            l.notifyJobStart(jobId);
        }
    }

    public synchronized void notifyJobFinish(JobId jobId) throws HyracksException {
        for (IJobLifecycleListener l : this.jobLifecycleListeners) {
            l.notifyJobFinish(jobId);
        }
    }

    public synchronized void notifyJobCreation(JobId jobId, IActivityClusterGraphGeneratorFactory acggf) throws HyracksException {
        for (IJobLifecycleListener l : this.jobLifecycleListeners) {
            l.notifyJobCreation(jobId, acggf);
        }
    }

    public void addClusterLifecycleListener(IClusterLifecycleListener clusterLifecycleListener) {
        this.clusterLifecycleListeners.add(clusterLifecycleListener);
    }

    public void notifyNodeJoin(String nodeId, Map<String, String> ncConfiguration) throws HyracksException {
        for (IClusterLifecycleListener l : this.clusterLifecycleListeners) {
            l.notifyNodeJoin(nodeId, ncConfiguration);
        }
    }

    public void notifyNodeFailure(Set<String> deadNodeIds) {
        for (IClusterLifecycleListener l : this.clusterLifecycleListeners) {
            l.notifyNodeFailure(deadNodeIds);
        }
    }
}

