/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.adminconsole.pages;

import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.adminconsole.pages.AbstractPage;
import edu.uci.ics.hyracks.control.cc.work.GetActivityClusterGraphJSONWork;
import edu.uci.ics.hyracks.control.cc.work.GetJobRunJSONWork;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.json.JSONArray;
import org.json.JSONObject;

public class JobDetailsPage
extends AbstractPage {
    private static final long serialVersionUID = 1L;
    private static final int HEIGHT = 29;

    public JobDetailsPage(PageParameters params) throws Exception {
        TaskProfile tp;
        JSONObject pO;
        ClusterControllerService ccs = this.getAdminConsoleApplication().getClusterControllerService();
        StringValue jobIdStr = params.get("job-id");
        JobId jobId = JobId.parse((String)jobIdStr.toString());
        GetActivityClusterGraphJSONWork gacgw = new GetActivityClusterGraphJSONWork(ccs, jobId);
        ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gacgw);
        Label jag = new Label("activity-cluster-graph", gacgw.getJSON().toString());
        jag.setEscapeModelStrings(false);
        this.add(new Component[]{jag});
        JSONObject jagO = gacgw.getJSON();
        HashMap<ActivityId, String> activityMap = new HashMap<ActivityId, String>();
        if (jagO.has("activities")) {
            JSONArray aArray = jagO.getJSONArray("activities");
            for (int i = 0; i < aArray.length(); ++i) {
                JSONObject aO = aArray.getJSONObject(i);
                ActivityId aid = ActivityId.parse((String)aO.getString("id"));
                String className = aO.getString("java-class");
                activityMap.put(aid, className);
            }
        }
        GetJobRunJSONWork gjrw = new GetJobRunJSONWork(ccs, jobId);
        ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gjrw);
        Label jobrun = new Label("job-run", gjrw.getJSON().toString());
        jobrun.setEscapeModelStrings(false);
        this.add(new Component[]{jobrun});
        JSONObject jrO = gjrw.getJSON();
        ArrayList<TaskClusterAttempt[]> tcList = new ArrayList<TaskClusterAttempt[]>();
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        if (jrO.has("activity-clusters")) {
            JSONArray acA = jrO.getJSONArray("activity-clusters");
            for (int i = 0; i < acA.length(); ++i) {
                JSONObject planO;
                JSONObject acO = acA.getJSONObject(i);
                if (!acO.has("plan") || !(planO = acO.getJSONObject("plan")).has("task-clusters")) continue;
                JSONArray tcA = planO.getJSONArray("task-clusters");
                for (int j = 0; j < tcA.length(); ++j) {
                    JSONObject tcO = tcA.getJSONObject(j);
                    String tcId = tcO.getString("task-cluster-id");
                    if (!tcO.has("attempts")) continue;
                    JSONArray tcaA = tcO.getJSONArray("attempts");
                    TaskClusterAttempt[] tcAttempts = new TaskClusterAttempt[tcaA.length()];
                    for (int k = 0; k < tcaA.length(); ++k) {
                        JSONObject tcaO = tcaA.getJSONObject(k);
                        int attempt = tcaO.getInt("attempt");
                        long startTime = tcaO.getLong("start-time");
                        long endTime = tcaO.getLong("end-time");
                        tcAttempts[k] = new TaskClusterAttempt(tcId, attempt, startTime, endTime);
                        if (startTime < minTime) {
                            minTime = startTime;
                        }
                        if (endTime > maxTime) {
                            maxTime = endTime;
                        }
                        if (!tcaO.has("task-attempts")) continue;
                        JSONArray taArray = tcaO.getJSONArray("task-attempts");
                        TaskClusterAttempt.access$002(tcAttempts[k], new TaskAttempt[taArray.length()]);
                        for (int l = 0; l < taArray.length(); ++l) {
                            TaskAttempt ta;
                            JSONObject taO = taArray.getJSONObject(l);
                            TaskAttemptId taId = TaskAttemptId.parse((String)taO.getString("task-attempt-id"));
                            ((TaskClusterAttempt)tcAttempts[k]).tasks[l] = ta = new TaskAttempt(taId, taO.getLong("start-time"), taO.getLong("end-time"));
                            TaskId tid = taId.getTaskId();
                            ta.name = (String)activityMap.get(tid.getActivityId());
                            ta.partition = tid.getPartition();
                        }
                        Arrays.sort(tcAttempts[k].tasks, new Comparator<TaskAttempt>(){

                            @Override
                            public int compare(TaskAttempt o1, TaskAttempt o2) {
                                return o1.startTime < o2.startTime ? -1 : (o1.startTime > o2.startTime ? 1 : 0);
                            }
                        });
                    }
                    Arrays.sort(tcAttempts, new Comparator<TaskClusterAttempt>(){

                        @Override
                        public int compare(TaskClusterAttempt o1, TaskClusterAttempt o2) {
                            return o1.startTime < o2.startTime ? -1 : (o1.startTime > o2.startTime ? 1 : 0);
                        }
                    });
                    tcList.add(tcAttempts);
                }
            }
        }
        HashMap<TaskAttemptId, TaskProfile> tpMap = new HashMap<TaskAttemptId, TaskProfile>();
        if (jrO.has("profile") && (pO = jrO.getJSONObject("profile")).has("joblets")) {
            JSONArray jobletsA = pO.getJSONArray("joblets");
            for (int i = 0; i < jobletsA.length(); ++i) {
                JSONObject jobletO = jobletsA.getJSONObject(i);
                if (!jobletO.has("tasks")) continue;
                JSONArray tasksA = jobletO.getJSONArray("tasks");
                for (int j = 0; j < tasksA.length(); ++j) {
                    JSONObject taskO = tasksA.getJSONObject(j);
                    ActivityId activityId = ActivityId.parse((String)taskO.getString("activity-id"));
                    int partition = taskO.getInt("partition");
                    int attempt = taskO.getInt("attempt");
                    TaskAttemptId taId = new TaskAttemptId(new TaskId(activityId, partition), attempt);
                    if (!taskO.has("partition-send-profile")) continue;
                    JSONArray taskProfilesA = taskO.getJSONArray("partition-send-profile");
                    for (int k = 0; k < taskProfilesA.length(); ++k) {
                        JSONObject ppO = taskProfilesA.getJSONObject(k);
                        long openTime = ppO.getLong("open-time");
                        long closeTime = ppO.getLong("close-time");
                        int resolution = ppO.getInt("resolution");
                        long offset = ppO.getLong("offset");
                        JSONArray frameTimesA = ppO.getJSONArray("frame-times");
                        long[] frameTimes = new long[frameTimesA.length()];
                        for (int l = 0; l < frameTimes.length; ++l) {
                            frameTimes[l] = (long)frameTimesA.getInt(l) + offset;
                        }
                        tp = new TaskProfile(taId, openTime, closeTime, frameTimes, resolution);
                        if (tpMap.containsKey(tp.taId)) continue;
                        tpMap.put(tp.taId, tp);
                    }
                }
            }
        }
        if (!tcList.isEmpty()) {
            Collections.sort(tcList, new Comparator<TaskClusterAttempt[]>(){

                @Override
                public int compare(TaskClusterAttempt[] o1, TaskClusterAttempt[] o2) {
                    if (o1.length == 0) {
                        return o2.length == 0 ? 0 : -1;
                    }
                    if (o2.length == 0) {
                        return 1;
                    }
                    return o1[0].startTime < o2[0].startTime ? -1 : (o1[0].startTime > o2[0].startTime ? 1 : 0);
                }
            });
            long range = maxTime - minTime;
            double leftOffset = 20.0;
            int xWidth = 1024;
            double width = (double)xWidth / (double)range;
            StringBuilder buffer = new StringBuilder();
            int y = 0;
            for (TaskClusterAttempt[] tcAttempts : tcList) {
                for (int i = 0; i < tcAttempts.length; ++i) {
                    TaskClusterAttempt tca = tcAttempts[i];
                    long startTime = tca.startTime - minTime;
                    long endTime = tca.endTime - minTime;
                    buffer.append("<rect x=\"").append((double)startTime * width + leftOffset).append("\" y=\"").append(y * 30).append("\" width=\"").append(width * (double)(endTime - startTime)).append("\" height=\"").append(29).append("\"/>\n");
                    buffer.append("<text x=\"").append((double)endTime * width + leftOffset + 20.0).append("\" y=\"").append(y * 30 + 21).append("\">").append(endTime - startTime + " ms").append("</text>\n");
                    ++y;
                    for (int j = 0; j < tca.tasks.length; ++j) {
                        TaskAttempt ta = tca.tasks[j];
                        long tStartTime = ta.startTime - minTime;
                        long tEndTime = ta.endTime - minTime;
                        buffer.append("<rect x=\"").append((double)tStartTime * width + leftOffset).append("\" y=\"").append(y * 30 + 7).append("\" width=\"").append(width * (double)(tEndTime - tStartTime)).append("\" height=\"").append(14).append("\" style=\"fill:rgb(255,255,255);stroke-width:1;stroke:rgb(0,0,0)\"/>\n");
                        buffer.append("<text x=\"").append((double)tEndTime * width + leftOffset + 20.0).append("\" y=\"").append(y * 30 + 21).append("\">").append(tEndTime - tStartTime + " ms (" + ta.name + ":" + ta.partition + ")").append("</text>\n");
                        tp = (TaskProfile)tpMap.get(ta.taId);
                        if (tp != null) {
                            for (int k = 0; k < tp.frameTimes.length; ++k) {
                                long taOpenTime = tp.openTime - minTime;
                                buffer.append("<rect x=\"").append((double)taOpenTime * width + leftOffset).append("\" y=\"").append(y * 30 + 7).append("\" width=\"1\" height=\"").append(14).append("\" style=\"fill:rgb(255,0,0);stroke-width:1;stroke:rgb(255,0,0)\"/>\n");
                                for (int l = 0; l < tp.frameTimes.length; ++l) {
                                    long ft = tp.frameTimes[l];
                                    long ftn = l < tp.frameTimes.length - 1 ? tp.frameTimes[l + 1] : ft;
                                    long taNextTime = ft - minTime;
                                    long barWidth = ftn - ft;
                                    buffer.append("<rect x=\"").append((double)taNextTime * width + leftOffset).append("\" y=\"").append(y * 30 + 7).append("\" width=\"").append(barWidth == 0L ? 1.0 : (double)barWidth * width).append("\" height=\"").append(14).append("\" style=\"fill:rgb(0,255,0);stroke-width:1;stroke:rgb(0,255,0)\"/>\n");
                                }
                                long taCloseTime = tp.closeTime - minTime;
                                buffer.append("<rect x=\"").append((double)taCloseTime * width + leftOffset).append("\" y=\"").append(y * 30 + 7).append("\" width=\"1\" height=\"").append(14).append("\" style=\"fill:rgb(0,0,255);stroke-width:1;stroke:rgb(0,0,255)\"/>\n");
                            }
                        }
                        ++y;
                    }
                }
            }
            buffer.append("<rect x=\"").append(leftOffset).append("\" y=\"").append(0).append("\" width=\"").append(1).append("\" height=\"").append((y + 2) * 30).append("\"/>\n");
            buffer.append("<rect x=\"").append(0).append("\" y=\"").append((y + 1) * 30).append("\" width=\"").append((double)xWidth + 2.0 * leftOffset).append("\" height=\"").append(1).append("\"/>\n");
            buffer.append("</svg>");
            Label markup = new Label("job-timeline", "<svg version=\"1.1\"\nxmlns=\"http://www.w3.org/2000/svg\" width=\"" + (double)xWidth * 1.5 + "\" height=\"" + (y + 2) * 30 + "\">\n" + buffer.toString());
            markup.setEscapeModelStrings(false);
            this.add(new Component[]{markup});
        } else {
            Label markup = new Label("job-timeline", "No information available yet");
            this.add(new Component[]{markup});
        }
    }

    private static class TaskProfile {
        private TaskAttemptId taId;
        private long openTime;
        private long closeTime;
        private long[] frameTimes;
        private int resolution;

        public TaskProfile(TaskAttemptId taId, long openTime, long closeTime, long[] frameTimes, int resolution) {
            this.taId = taId;
            this.openTime = openTime;
            this.closeTime = closeTime;
            this.frameTimes = frameTimes;
            this.resolution = resolution;
        }
    }

    private static class TaskClusterAttempt {
        private String tcId;
        private int attempt;
        private long startTime;
        private long endTime;
        private TaskAttempt[] tasks;

        public TaskClusterAttempt(String tcId, int attempt, long startTime, long endTime) {
            this.tcId = tcId;
            this.attempt = attempt;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        static /* synthetic */ TaskAttempt[] access$002(TaskClusterAttempt x0, TaskAttempt[] x1) {
            x0.tasks = x1;
            return x1;
        }
    }

    private static class TaskAttempt {
        private TaskAttemptId taId;
        private long startTime;
        private long endTime;
        private String name;
        private int partition;

        public TaskAttempt(TaskAttemptId taId, long startTime, long endTime) {
            this.taId = taId;
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }
}

