/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.adminconsole.pages;

import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.adminconsole.pages.AbstractPage;
import edu.uci.ics.hyracks.control.cc.adminconsole.pages.JobDetailsPage;
import edu.uci.ics.hyracks.control.cc.adminconsole.pages.NodeDetailsPage;
import edu.uci.ics.hyracks.control.cc.web.util.JSONUtils;
import edu.uci.ics.hyracks.control.cc.work.GetJobSummariesJSONWork;
import edu.uci.ics.hyracks.control.cc.work.GetNodeSummariesJSONWork;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IndexPage
extends AbstractPage {
    private static final long serialVersionUID = 1L;

    public IndexPage() throws Exception {
        ClusterControllerService ccs = this.getAdminConsoleApplication().getClusterControllerService();
        GetNodeSummariesJSONWork gnse = new GetNodeSummariesJSONWork(ccs);
        ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gnse);
        JSONArray nodeSummaries = gnse.getSummaries();
        this.add(new Component[]{new Label("node-count", String.valueOf(nodeSummaries.length()))});
        ListView<JSONObject> nodeList = new ListView<JSONObject>("node-list", JSONUtils.toList(nodeSummaries)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<JSONObject> item) {
                JSONObject o = (JSONObject)item.getModelObject();
                try {
                    item.add(new Component[]{new Label("node-id", o.getString("node-id"))});
                    item.add(new Component[]{new Label("heap-used", o.getString("heap-used"))});
                    item.add(new Component[]{new Label("system-load-average", o.getString("system-load-average"))});
                    PageParameters params = new PageParameters();
                    params.add("node-id", (Object)o.getString("node-id"));
                    item.add(new Component[]{new BookmarkablePageLink("node-details", NodeDetailsPage.class, params)});
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.add(new Component[]{nodeList});
        GetJobSummariesJSONWork gjse = new GetJobSummariesJSONWork(ccs);
        ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gjse);
        JSONArray jobSummaries = gjse.getSummaries();
        ListView<JSONObject> jobList = new ListView<JSONObject>("jobs-list", JSONUtils.toList(jobSummaries)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<JSONObject> item) {
                JSONObject o = (JSONObject)item.getModelObject();
                try {
                    item.add(new Component[]{new Label("job-id", o.getString("job-id"))});
                    item.add(new Component[]{new Label("status", o.getString("status"))});
                    item.add(new Component[]{new Label("create-time", o.getString("create-time"))});
                    item.add(new Component[]{new Label("start-time", o.getString("start-time"))});
                    item.add(new Component[]{new Label("end-time", o.getString("end-time"))});
                    PageParameters params = new PageParameters();
                    params.add("job-id", (Object)o.getString("job-id"));
                    item.add(new Component[]{new BookmarkablePageLink("job-details", JobDetailsPage.class, params)});
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.add(new Component[]{jobList});
    }
}

