/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc;

import edu.uci.ics.hyracks.api.comm.NetworkAddress;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.common.base.INodeController;
import edu.uci.ics.hyracks.control.common.controllers.NCConfig;
import edu.uci.ics.hyracks.control.common.controllers.NodeRegistration;
import edu.uci.ics.hyracks.control.common.heartbeat.HeartbeatData;
import edu.uci.ics.hyracks.control.common.heartbeat.HeartbeatSchema;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NodeControllerState {
    private static final int RRD_SIZE = 720;
    private final INodeController nodeController;
    private final NCConfig ncConfig;
    private final NetworkAddress dataPort;
    private final NetworkAddress datasetPort;
    private final Set<JobId> activeJobIds;
    private final String osName;
    private final String arch;
    private final String osVersion;
    private final int nProcessors;
    private final String vmName;
    private final String vmVersion;
    private final String vmVendor;
    private final String classpath;
    private final String libraryPath;
    private final String bootClasspath;
    private final List<String> inputArguments;
    private final Map<String, String> systemProperties;
    private final HeartbeatSchema hbSchema;
    private final long[] hbTime;
    private final long[] heapInitSize;
    private final long[] heapUsedSize;
    private final long[] heapCommittedSize;
    private final long[] heapMaxSize;
    private final long[] nonheapInitSize;
    private final long[] nonheapUsedSize;
    private final long[] nonheapCommittedSize;
    private final long[] nonheapMaxSize;
    private final int[] threadCount;
    private final int[] peakThreadCount;
    private final double[] systemLoadAverage;
    private final String[] gcNames;
    private final long[][] gcCollectionCounts;
    private final long[][] gcCollectionTimes;
    private final long[] netPayloadBytesRead;
    private final long[] netPayloadBytesWritten;
    private final long[] netSignalingBytesRead;
    private final long[] netSignalingBytesWritten;
    private final long[] datasetNetPayloadBytesRead;
    private final long[] datasetNetPayloadBytesWritten;
    private final long[] datasetNetSignalingBytesRead;
    private final long[] datasetNetSignalingBytesWritten;
    private final long[] ipcMessagesSent;
    private final long[] ipcMessageBytesSent;
    private final long[] ipcMessagesReceived;
    private final long[] ipcMessageBytesReceived;
    private final long[] diskReads;
    private final long[] diskWrites;
    private int rrdPtr;
    private int lastHeartbeatDuration;

    public NodeControllerState(INodeController nodeController, NodeRegistration reg) {
        this.nodeController = nodeController;
        this.ncConfig = reg.getNCConfig();
        this.dataPort = reg.getDataPort();
        this.datasetPort = reg.getDatasetPort();
        this.activeJobIds = new HashSet<JobId>();
        this.osName = reg.getOSName();
        this.arch = reg.getArch();
        this.osVersion = reg.getOSVersion();
        this.nProcessors = reg.getNProcessors();
        this.vmName = reg.getVmName();
        this.vmVersion = reg.getVmVersion();
        this.vmVendor = reg.getVmVendor();
        this.classpath = reg.getClasspath();
        this.libraryPath = reg.getLibraryPath();
        this.bootClasspath = reg.getBootClasspath();
        this.inputArguments = reg.getInputArguments();
        this.systemProperties = reg.getSystemProperties();
        this.hbSchema = reg.getHeartbeatSchema();
        this.hbTime = new long[720];
        this.heapInitSize = new long[720];
        this.heapUsedSize = new long[720];
        this.heapCommittedSize = new long[720];
        this.heapMaxSize = new long[720];
        this.nonheapInitSize = new long[720];
        this.nonheapUsedSize = new long[720];
        this.nonheapCommittedSize = new long[720];
        this.nonheapMaxSize = new long[720];
        this.threadCount = new int[720];
        this.peakThreadCount = new int[720];
        this.systemLoadAverage = new double[720];
        HeartbeatSchema.GarbageCollectorInfo[] gcInfos = this.hbSchema.getGarbageCollectorInfos();
        int gcN = gcInfos.length;
        this.gcNames = new String[gcN];
        for (int i = 0; i < gcN; ++i) {
            this.gcNames[i] = gcInfos[i].getName();
        }
        this.gcCollectionCounts = new long[gcN][720];
        this.gcCollectionTimes = new long[gcN][720];
        this.netPayloadBytesRead = new long[720];
        this.netPayloadBytesWritten = new long[720];
        this.netSignalingBytesRead = new long[720];
        this.netSignalingBytesWritten = new long[720];
        this.datasetNetPayloadBytesRead = new long[720];
        this.datasetNetPayloadBytesWritten = new long[720];
        this.datasetNetSignalingBytesRead = new long[720];
        this.datasetNetSignalingBytesWritten = new long[720];
        this.ipcMessagesSent = new long[720];
        this.ipcMessageBytesSent = new long[720];
        this.ipcMessagesReceived = new long[720];
        this.ipcMessageBytesReceived = new long[720];
        this.diskReads = new long[720];
        this.diskWrites = new long[720];
        this.rrdPtr = 0;
    }

    public void notifyHeartbeat(HeartbeatData hbData) {
        this.lastHeartbeatDuration = 0;
        this.hbTime[this.rrdPtr] = System.currentTimeMillis();
        if (hbData != null) {
            this.heapInitSize[this.rrdPtr] = hbData.heapInitSize;
            this.heapUsedSize[this.rrdPtr] = hbData.heapUsedSize;
            this.heapCommittedSize[this.rrdPtr] = hbData.heapCommittedSize;
            this.heapMaxSize[this.rrdPtr] = hbData.heapMaxSize;
            this.nonheapInitSize[this.rrdPtr] = hbData.nonheapInitSize;
            this.nonheapUsedSize[this.rrdPtr] = hbData.nonheapUsedSize;
            this.nonheapCommittedSize[this.rrdPtr] = hbData.nonheapCommittedSize;
            this.nonheapMaxSize[this.rrdPtr] = hbData.nonheapMaxSize;
            this.threadCount[this.rrdPtr] = hbData.threadCount;
            this.peakThreadCount[this.rrdPtr] = hbData.peakThreadCount;
            this.systemLoadAverage[this.rrdPtr] = hbData.systemLoadAverage;
            int gcN = this.hbSchema.getGarbageCollectorInfos().length;
            for (int i = 0; i < gcN; ++i) {
                this.gcCollectionCounts[i][this.rrdPtr] = hbData.gcCollectionCounts[i];
                this.gcCollectionTimes[i][this.rrdPtr] = hbData.gcCollectionTimes[i];
            }
            this.netPayloadBytesRead[this.rrdPtr] = hbData.netPayloadBytesRead;
            this.netPayloadBytesWritten[this.rrdPtr] = hbData.netPayloadBytesWritten;
            this.netSignalingBytesRead[this.rrdPtr] = hbData.netSignalingBytesRead;
            this.netSignalingBytesWritten[this.rrdPtr] = hbData.netSignalingBytesWritten;
            this.datasetNetPayloadBytesRead[this.rrdPtr] = hbData.datasetNetPayloadBytesRead;
            this.datasetNetPayloadBytesWritten[this.rrdPtr] = hbData.datasetNetPayloadBytesWritten;
            this.datasetNetSignalingBytesRead[this.rrdPtr] = hbData.datasetNetSignalingBytesRead;
            this.datasetNetSignalingBytesWritten[this.rrdPtr] = hbData.datasetNetSignalingBytesWritten;
            this.ipcMessagesSent[this.rrdPtr] = hbData.ipcMessagesSent;
            this.ipcMessageBytesSent[this.rrdPtr] = hbData.ipcMessageBytesSent;
            this.ipcMessagesReceived[this.rrdPtr] = hbData.ipcMessagesReceived;
            this.ipcMessageBytesReceived[this.rrdPtr] = hbData.ipcMessageBytesReceived;
            this.diskReads[this.rrdPtr] = hbData.diskReads;
            this.diskWrites[this.rrdPtr] = hbData.diskWrites;
            this.rrdPtr = (this.rrdPtr + 1) % 720;
        }
    }

    public int incrementLastHeartbeatDuration() {
        return this.lastHeartbeatDuration++;
    }

    public int getLastHeartbeatDuration() {
        return this.lastHeartbeatDuration;
    }

    public INodeController getNodeController() {
        return this.nodeController;
    }

    public NCConfig getNCConfig() {
        return this.ncConfig;
    }

    public Set<JobId> getActiveJobIds() {
        return this.activeJobIds;
    }

    public NetworkAddress getDataPort() {
        return this.dataPort;
    }

    public NetworkAddress getDatasetPort() {
        return this.datasetPort;
    }

    public JSONObject toSummaryJSON() throws JSONException {
        JSONObject o = new JSONObject();
        o.put("node-id", (Object)this.ncConfig.nodeId);
        o.put("heap-used", this.heapUsedSize[(this.rrdPtr + 720 - 1) % 720]);
        o.put("system-load-average", this.systemLoadAverage[(this.rrdPtr + 720 - 1) % 720]);
        return o;
    }

    public JSONObject toDetailedJSON() throws JSONException {
        JSONObject o = new JSONObject();
        o.put("node-id", (Object)this.ncConfig.nodeId);
        o.put("os-name", (Object)this.osName);
        o.put("arch", (Object)this.arch);
        o.put("os-version", (Object)this.osVersion);
        o.put("num-processors", this.nProcessors);
        o.put("vm-name", (Object)this.vmName);
        o.put("vm-version", (Object)this.vmVersion);
        o.put("vm-vendor", (Object)this.vmVendor);
        o.put("classpath", (Object)this.classpath);
        o.put("library-path", (Object)this.libraryPath);
        o.put("boot-classpath", (Object)this.bootClasspath);
        o.put("input-arguments", (Object)new JSONArray(this.inputArguments));
        o.put("rrd-ptr", this.rrdPtr);
        o.put("heartbeat-times", (Object)this.hbTime);
        o.put("heap-init-sizes", (Object)this.heapInitSize);
        o.put("heap-used-sizes", (Object)this.heapUsedSize);
        o.put("heap-committed-sizes", (Object)this.heapCommittedSize);
        o.put("heap-max-sizes", (Object)this.heapMaxSize);
        o.put("nonheap-init-sizes", (Object)this.nonheapInitSize);
        o.put("nonheap-used-sizes", (Object)this.nonheapUsedSize);
        o.put("nonheap-committed-sizes", (Object)this.nonheapCommittedSize);
        o.put("nonheap-max-sizes", (Object)this.nonheapMaxSize);
        o.put("thread-counts", (Object)this.threadCount);
        o.put("peak-thread-counts", (Object)this.peakThreadCount);
        o.put("system-load-averages", (Object)this.systemLoadAverage);
        o.put("gc-names", (Object)this.gcNames);
        o.put("gc-collection-counts", (Object)this.gcCollectionCounts);
        o.put("gc-collection-times", (Object)this.gcCollectionTimes);
        o.put("net-payload-bytes-read", (Object)this.netPayloadBytesRead);
        o.put("net-payload-bytes-written", (Object)this.netPayloadBytesWritten);
        o.put("net-signaling-bytes-read", (Object)this.netSignalingBytesRead);
        o.put("net-signaling-bytes-written", (Object)this.netSignalingBytesWritten);
        o.put("dataset-net-payload-bytes-read", (Object)this.datasetNetPayloadBytesRead);
        o.put("dataset-net-payload-bytes-written", (Object)this.datasetNetPayloadBytesWritten);
        o.put("dataset-net-signaling-bytes-read", (Object)this.datasetNetSignalingBytesRead);
        o.put("dataset-net-signaling-bytes-written", (Object)this.datasetNetSignalingBytesWritten);
        o.put("ipc-messages-sent", (Object)this.ipcMessagesSent);
        o.put("ipc-message-bytes-sent", (Object)this.ipcMessageBytesSent);
        o.put("ipc-messages-received", (Object)this.ipcMessagesReceived);
        o.put("ipc-message-bytes-received", (Object)this.ipcMessageBytesReceived);
        o.put("disk-reads", (Object)this.diskReads);
        o.put("disk-writes", (Object)this.diskWrites);
        return o;
    }
}

