/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc;

import edu.uci.ics.hyracks.api.application.ICCApplicationContext;
import edu.uci.ics.hyracks.api.application.ICCApplicationEntryPoint;
import edu.uci.ics.hyracks.api.client.ClusterControllerInfo;
import edu.uci.ics.hyracks.api.client.HyracksClientInterfaceFunctions;
import edu.uci.ics.hyracks.api.client.NodeControllerInfo;
import edu.uci.ics.hyracks.api.comm.NetworkAddress;
import edu.uci.ics.hyracks.api.context.ICCContext;
import edu.uci.ics.hyracks.api.dataset.DatasetDirectoryRecord;
import edu.uci.ics.hyracks.api.dataset.DatasetJobRecord;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.job.JobInfo;
import edu.uci.ics.hyracks.api.job.JobStatus;
import edu.uci.ics.hyracks.api.topology.ClusterTopology;
import edu.uci.ics.hyracks.api.topology.TopologyDefinitionParser;
import edu.uci.ics.hyracks.control.cc.NodeControllerState;
import edu.uci.ics.hyracks.control.cc.application.CCApplicationContext;
import edu.uci.ics.hyracks.control.cc.dataset.DatasetDirectoryService;
import edu.uci.ics.hyracks.control.cc.dataset.IDatasetDirectoryService;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.cc.web.WebServer;
import edu.uci.ics.hyracks.control.cc.work.ApplicationMessageWork;
import edu.uci.ics.hyracks.control.cc.work.CliDeployBinaryWork;
import edu.uci.ics.hyracks.control.cc.work.CliUnDeployBinaryWork;
import edu.uci.ics.hyracks.control.cc.work.GatherStateDumpsWork;
import edu.uci.ics.hyracks.control.cc.work.GetDatasetDirectoryServiceInfoWork;
import edu.uci.ics.hyracks.control.cc.work.GetIpAddressNodeNameMapWork;
import edu.uci.ics.hyracks.control.cc.work.GetJobInfoWork;
import edu.uci.ics.hyracks.control.cc.work.GetJobStatusWork;
import edu.uci.ics.hyracks.control.cc.work.GetNodeControllersInfoWork;
import edu.uci.ics.hyracks.control.cc.work.GetResultPartitionLocationsWork;
import edu.uci.ics.hyracks.control.cc.work.GetResultStatusWork;
import edu.uci.ics.hyracks.control.cc.work.JobStartWork;
import edu.uci.ics.hyracks.control.cc.work.JobletCleanupNotificationWork;
import edu.uci.ics.hyracks.control.cc.work.NodeHeartbeatWork;
import edu.uci.ics.hyracks.control.cc.work.NotifyDeployBinaryWork;
import edu.uci.ics.hyracks.control.cc.work.NotifyStateDumpResponse;
import edu.uci.ics.hyracks.control.cc.work.RegisterNodeWork;
import edu.uci.ics.hyracks.control.cc.work.RegisterPartitionAvailibilityWork;
import edu.uci.ics.hyracks.control.cc.work.RegisterPartitionRequestWork;
import edu.uci.ics.hyracks.control.cc.work.RegisterResultPartitionLocationWork;
import edu.uci.ics.hyracks.control.cc.work.RemoveDeadNodesWork;
import edu.uci.ics.hyracks.control.cc.work.ReportProfilesWork;
import edu.uci.ics.hyracks.control.cc.work.ReportResultPartitionFailureWork;
import edu.uci.ics.hyracks.control.cc.work.ReportResultPartitionWriteCompletionWork;
import edu.uci.ics.hyracks.control.cc.work.TaskCompleteWork;
import edu.uci.ics.hyracks.control.cc.work.TaskFailureWork;
import edu.uci.ics.hyracks.control.cc.work.UnregisterNodeWork;
import edu.uci.ics.hyracks.control.cc.work.WaitForJobCompletionWork;
import edu.uci.ics.hyracks.control.common.AbstractRemoteService;
import edu.uci.ics.hyracks.control.common.context.ServerContext;
import edu.uci.ics.hyracks.control.common.controllers.CCConfig;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentRun;
import edu.uci.ics.hyracks.control.common.ipc.CCNCFunctions;
import edu.uci.ics.hyracks.control.common.logs.LogFile;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.common.work.IPCResponder;
import edu.uci.ics.hyracks.control.common.work.IResultCallback;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import edu.uci.ics.hyracks.control.common.work.WorkQueue;
import edu.uci.ics.hyracks.ipc.api.IIPCHandle;
import edu.uci.ics.hyracks.ipc.api.IIPCI;
import edu.uci.ics.hyracks.ipc.api.IPayloadSerializerDeserializer;
import edu.uci.ics.hyracks.ipc.exceptions.IPCException;
import edu.uci.ics.hyracks.ipc.impl.IPCSystem;
import edu.uci.ics.hyracks.ipc.impl.JavaSerializationBasedPayloadSerializerDeserializer;
import java.io.File;
import java.io.FileReader;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;

public class ClusterControllerService
extends AbstractRemoteService {
    private static Logger LOGGER = Logger.getLogger(ClusterControllerService.class.getName());
    private final CCConfig ccConfig;
    private IPCSystem clusterIPC;
    private IPCSystem clientIPC;
    private final LogFile jobLog;
    private final Map<String, NodeControllerState> nodeRegistry;
    private final Map<String, Set<String>> ipAddressNodeNameMap;
    private final ServerContext serverCtx;
    private final WebServer webServer;
    private ClusterControllerInfo info;
    private CCApplicationContext appCtx;
    private final Map<JobId, JobRun> activeRunMap;
    private final Map<JobId, JobRun> runMapArchive;
    private final Map<JobId, List<Exception>> runMapHistory;
    private final WorkQueue workQueue;
    private ExecutorService executor;
    private final Timer timer;
    private final ICCContext ccContext;
    private final DeadNodeSweeper sweeper;
    private final IDatasetDirectoryService datasetDirectoryService;
    private long jobCounter;
    private final Map<DeploymentId, DeploymentRun> deploymentRunMap;
    private final Map<String, GatherStateDumpsWork.StateDumpRun> stateDumpRunMap;

    public ClusterControllerService(final CCConfig ccConfig) throws Exception {
        this.ccConfig = ccConfig;
        File jobLogFolder = new File(ccConfig.ccRoot, "logs/jobs");
        this.jobLog = new LogFile(jobLogFolder);
        this.nodeRegistry = new LinkedHashMap<String, NodeControllerState>();
        this.ipAddressNodeNameMap = new HashMap<String, Set<String>>();
        this.serverCtx = new ServerContext(ServerContext.ServerType.CLUSTER_CONTROLLER, new File(ccConfig.ccRoot));
        ClusterControllerIPCI ccIPCI = new ClusterControllerIPCI();
        this.clusterIPC = new IPCSystem(new InetSocketAddress(ccConfig.clusterNetPort), (IIPCI)ccIPCI, (IPayloadSerializerDeserializer)new CCNCFunctions.SerializerDeserializer());
        HyracksClientInterfaceIPCI ciIPCI = new HyracksClientInterfaceIPCI();
        this.clientIPC = new IPCSystem(new InetSocketAddress(ccConfig.clientNetIpAddress, ccConfig.clientNetPort), (IIPCI)ciIPCI, (IPayloadSerializerDeserializer)new JavaSerializationBasedPayloadSerializerDeserializer());
        this.webServer = new WebServer(this);
        this.activeRunMap = new HashMap<JobId, JobRun>();
        this.runMapArchive = new LinkedHashMap<JobId, JobRun>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<JobId, JobRun> eldest) {
                return this.size() > ccConfig.jobHistorySize;
            }
        };
        this.runMapHistory = new LinkedHashMap<JobId, List<Exception>>(){
            private static final long serialVersionUID = 1L;
            private int allowedSize;
            {
                this.allowedSize = 100 * (ccConfig.jobHistorySize + 1);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<JobId, List<Exception>> eldest) {
                return this.size() > this.allowedSize;
            }
        };
        this.workQueue = new WorkQueue();
        this.timer = new Timer(true);
        final ClusterTopology topology = ClusterControllerService.computeClusterTopology(ccConfig);
        this.ccContext = new ICCContext(){

            public void getIPAddressNodeMap(Map<String, Set<String>> map) throws Exception {
                GetIpAddressNodeNameMapWork ginmw = new GetIpAddressNodeNameMapWork(ClusterControllerService.this, map);
                ClusterControllerService.this.workQueue.scheduleAndSync((SynchronizableWork)ginmw);
            }

            public ClusterControllerInfo getClusterControllerInfo() {
                return ClusterControllerService.this.info;
            }

            public ClusterTopology getClusterTopology() {
                return topology;
            }
        };
        this.sweeper = new DeadNodeSweeper();
        this.datasetDirectoryService = new DatasetDirectoryService(ccConfig.resultTTL, ccConfig.resultSweepThreshold);
        this.jobCounter = 0L;
        this.deploymentRunMap = new HashMap<DeploymentId, DeploymentRun>();
        this.stateDumpRunMap = new HashMap<String, GatherStateDumpsWork.StateDumpRun>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClusterTopology computeClusterTopology(CCConfig ccConfig) throws Exception {
        if (ccConfig.clusterTopologyDefinition == null) {
            return null;
        }
        FileReader fr = new FileReader(ccConfig.clusterTopologyDefinition);
        InputSource in = new InputSource(fr);
        try {
            ClusterTopology clusterTopology = TopologyDefinitionParser.parse((InputSource)in);
            return clusterTopology;
        }
        finally {
            fr.close();
        }
    }

    public void start() throws Exception {
        LOGGER.log(Level.INFO, "Starting ClusterControllerService: " + (Object)((Object)this));
        this.clusterIPC.start();
        this.clientIPC.start();
        this.webServer.setPort(this.ccConfig.httpPort);
        this.webServer.start();
        this.workQueue.start();
        this.info = new ClusterControllerInfo(this.ccConfig.clientNetIpAddress, this.ccConfig.clientNetPort, this.webServer.getListeningPort());
        this.timer.schedule((TimerTask)this.sweeper, 0L, (long)this.ccConfig.heartbeatPeriod);
        this.jobLog.open();
        this.startApplication();
        this.datasetDirectoryService.init(this.executor);
        LOGGER.log(Level.INFO, "Started ClusterControllerService");
    }

    private void startApplication() throws Exception {
        this.appCtx = new CCApplicationContext(this.serverCtx, this.ccContext);
        this.appCtx.addJobLifecycleListener(this.datasetDirectoryService);
        String className = this.ccConfig.appCCMainClass;
        if (className != null) {
            Class<?> c = Class.forName(className);
            ICCApplicationEntryPoint aep = (ICCApplicationEntryPoint)c.newInstance();
            String[] args = this.ccConfig.appArgs == null ? null : this.ccConfig.appArgs.toArray(new String[this.ccConfig.appArgs.size()]);
            aep.start((ICCApplicationContext)this.appCtx, args);
        }
        this.executor = Executors.newCachedThreadPool(this.appCtx.getThreadFactory());
    }

    public void stop() throws Exception {
        LOGGER.log(Level.INFO, "Stopping ClusterControllerService");
        this.executor.shutdownNow();
        this.webServer.stop();
        this.sweeper.cancel();
        this.workQueue.stop();
        this.jobLog.close();
        LOGGER.log(Level.INFO, "Stopped ClusterControllerService");
    }

    public ServerContext getServerContext() {
        return this.serverCtx;
    }

    public ICCContext getCCContext() {
        return this.ccContext;
    }

    public Map<JobId, JobRun> getActiveRunMap() {
        return this.activeRunMap;
    }

    public Map<JobId, JobRun> getRunMapArchive() {
        return this.runMapArchive;
    }

    public Map<JobId, List<Exception>> getRunHistory() {
        return this.runMapHistory;
    }

    public Map<String, Set<String>> getIpAddressNodeNameMap() {
        return this.ipAddressNodeNameMap;
    }

    public LogFile getJobLogFile() {
        return this.jobLog;
    }

    public WorkQueue getWorkQueue() {
        return this.workQueue;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Map<String, NodeControllerState> getNodeMap() {
        return this.nodeRegistry;
    }

    public CCConfig getConfig() {
        return this.ccConfig;
    }

    public CCApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    private JobId createJobId() {
        return new JobId(this.jobCounter++);
    }

    public ClusterControllerInfo getClusterControllerInfo() {
        return this.info;
    }

    public CCConfig getCCConfig() {
        return this.ccConfig;
    }

    public IPCSystem getClusterIPC() {
        return this.clusterIPC;
    }

    public NetworkAddress getDatasetDirectoryServiceInfo() {
        return new NetworkAddress(this.ccConfig.clientNetIpAddress.getBytes(), this.ccConfig.clientNetPort);
    }

    public IDatasetDirectoryService getDatasetDirectoryService() {
        return this.datasetDirectoryService;
    }

    public synchronized void addStateDumpRun(String id, GatherStateDumpsWork.StateDumpRun sdr) {
        this.stateDumpRunMap.put(id, sdr);
    }

    public synchronized GatherStateDumpsWork.StateDumpRun getStateDumpRun(String id) {
        return this.stateDumpRunMap.get(id);
    }

    public synchronized void removeStateDumpRun(String id) {
        this.stateDumpRunMap.remove(id);
    }

    public synchronized void addDeploymentRun(DeploymentId deploymentKey, DeploymentRun dRun) {
        this.deploymentRunMap.put(deploymentKey, dRun);
    }

    public synchronized DeploymentRun getDeploymentRun(DeploymentId deploymentKey) {
        return this.deploymentRunMap.get(deploymentKey);
    }

    public synchronized void removeDeploymentRun(DeploymentId deploymentKey) {
        this.deploymentRunMap.remove(deploymentKey);
    }

    private class ClusterControllerIPCI
    implements IIPCI {
        private ClusterControllerIPCI() {
        }

        public void deliverIncomingMessage(final IIPCHandle handle, long mid, long rmid, Object payload, Exception exception) {
            CCNCFunctions.Function fn = (CCNCFunctions.Function)payload;
            switch (fn.getFunctionId()) {
                case REGISTER_NODE: {
                    CCNCFunctions.RegisterNodeFunction rnf = (CCNCFunctions.RegisterNodeFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new RegisterNodeWork(ClusterControllerService.this, rnf.getNodeRegistration()));
                    return;
                }
                case UNREGISTER_NODE: {
                    CCNCFunctions.UnregisterNodeFunction unf = (CCNCFunctions.UnregisterNodeFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new UnregisterNodeWork(ClusterControllerService.this, unf.getNodeId()));
                    return;
                }
                case NODE_HEARTBEAT: {
                    CCNCFunctions.NodeHeartbeatFunction nhf = (CCNCFunctions.NodeHeartbeatFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new NodeHeartbeatWork(ClusterControllerService.this, nhf.getNodeId(), nhf.getHeartbeatData()));
                    return;
                }
                case NOTIFY_JOBLET_CLEANUP: {
                    CCNCFunctions.NotifyJobletCleanupFunction njcf = (CCNCFunctions.NotifyJobletCleanupFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new JobletCleanupNotificationWork(ClusterControllerService.this, njcf.getJobId(), njcf.getNodeId()));
                    return;
                }
                case NOTIFY_DEPLOY_BINARY: {
                    CCNCFunctions.NotifyDeployBinaryFunction ndbf = (CCNCFunctions.NotifyDeployBinaryFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new NotifyDeployBinaryWork(ClusterControllerService.this, ndbf.getDeploymentId(), ndbf.getNodeId(), ndbf.getDeploymentStatus()));
                    return;
                }
                case REPORT_PROFILE: {
                    CCNCFunctions.ReportProfileFunction rpf = (CCNCFunctions.ReportProfileFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new ReportProfilesWork(ClusterControllerService.this, rpf.getProfiles()));
                    return;
                }
                case NOTIFY_TASK_COMPLETE: {
                    CCNCFunctions.NotifyTaskCompleteFunction ntcf = (CCNCFunctions.NotifyTaskCompleteFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new TaskCompleteWork(ClusterControllerService.this, ntcf.getJobId(), ntcf.getTaskId(), ntcf.getNodeId(), ntcf.getStatistics()));
                    return;
                }
                case NOTIFY_TASK_FAILURE: {
                    CCNCFunctions.NotifyTaskFailureFunction ntff = (CCNCFunctions.NotifyTaskFailureFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new TaskFailureWork(ClusterControllerService.this, ntff.getJobId(), ntff.getTaskId(), ntff.getNodeId(), ntff.getExceptions()));
                    return;
                }
                case REGISTER_PARTITION_PROVIDER: {
                    CCNCFunctions.RegisterPartitionProviderFunction rppf = (CCNCFunctions.RegisterPartitionProviderFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new RegisterPartitionAvailibilityWork(ClusterControllerService.this, rppf.getPartitionDescriptor()));
                    return;
                }
                case REGISTER_PARTITION_REQUEST: {
                    CCNCFunctions.RegisterPartitionRequestFunction rprf = (CCNCFunctions.RegisterPartitionRequestFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new RegisterPartitionRequestWork(ClusterControllerService.this, rprf.getPartitionRequest()));
                    return;
                }
                case REGISTER_RESULT_PARTITION_LOCATION: {
                    CCNCFunctions.RegisterResultPartitionLocationFunction rrplf = (CCNCFunctions.RegisterResultPartitionLocationFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new RegisterResultPartitionLocationWork(ClusterControllerService.this, rrplf.getJobId(), rrplf.getResultSetId(), rrplf.getOrderedResult(), rrplf.getPartition(), rrplf.getNPartitions(), rrplf.getNetworkAddress()));
                    return;
                }
                case REPORT_RESULT_PARTITION_WRITE_COMPLETION: {
                    CCNCFunctions.ReportResultPartitionWriteCompletionFunction rrplf = (CCNCFunctions.ReportResultPartitionWriteCompletionFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new ReportResultPartitionWriteCompletionWork(ClusterControllerService.this, rrplf.getJobId(), rrplf.getResultSetId(), rrplf.getPartition()));
                    return;
                }
                case REPORT_RESULT_PARTITION_FAILURE: {
                    CCNCFunctions.ReportResultPartitionFailureFunction rrplf = (CCNCFunctions.ReportResultPartitionFailureFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new ReportResultPartitionFailureWork(ClusterControllerService.this, rrplf.getJobId(), rrplf.getResultSetId(), rrplf.getPartition()));
                    return;
                }
                case SEND_APPLICATION_MESSAGE: {
                    CCNCFunctions.SendApplicationMessageFunction rsf = (CCNCFunctions.SendApplicationMessageFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new ApplicationMessageWork(ClusterControllerService.this, rsf.getMessage(), rsf.getDeploymentId(), rsf.getNodeId()));
                    return;
                }
                case GET_NODE_CONTROLLERS_INFO: {
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new GetNodeControllersInfoWork(ClusterControllerService.this, new IResultCallback<Map<String, NodeControllerInfo>>(){

                        public void setValue(Map<String, NodeControllerInfo> result) {
                            new IPCResponder(handle, -1L).setValue((Object)new CCNCFunctions.GetNodeControllersInfoResponseFunction(result));
                        }

                        public void setException(Exception e) {
                        }
                    }));
                    return;
                }
                case STATE_DUMP_RESPONSE: {
                    CCNCFunctions.StateDumpResponseFunction dsrf = (CCNCFunctions.StateDumpResponseFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new NotifyStateDumpResponse(ClusterControllerService.this, dsrf.getNodeId(), dsrf.getStateDumpId(), dsrf.getState()));
                    return;
                }
            }
            LOGGER.warning("Unknown function: " + fn.getFunctionId());
        }
    }

    private class HyracksClientInterfaceIPCI
    implements IIPCI {
        private HyracksClientInterfaceIPCI() {
        }

        public void deliverIncomingMessage(IIPCHandle handle, long mid, long rmid, Object payload, Exception exception) {
            HyracksClientInterfaceFunctions.Function fn = (HyracksClientInterfaceFunctions.Function)payload;
            switch (fn.getFunctionId()) {
                case GET_CLUSTER_CONTROLLER_INFO: {
                    try {
                        handle.send(mid, (Object)ClusterControllerService.this.info, null);
                    }
                    catch (IPCException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                case GET_JOB_STATUS: {
                    HyracksClientInterfaceFunctions.GetJobStatusFunction gjsf = (HyracksClientInterfaceFunctions.GetJobStatusFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new GetJobStatusWork(ClusterControllerService.this, gjsf.getJobId(), (IResultCallback<JobStatus>)new IPCResponder(handle, mid)));
                    return;
                }
                case GET_JOB_INFO: {
                    HyracksClientInterfaceFunctions.GetJobInfoFunction gjsf = (HyracksClientInterfaceFunctions.GetJobInfoFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new GetJobInfoWork(ClusterControllerService.this, gjsf.getJobId(), (IResultCallback<JobInfo>)new IPCResponder(handle, mid)));
                    return;
                }
                case START_JOB: {
                    HyracksClientInterfaceFunctions.StartJobFunction sjf = (HyracksClientInterfaceFunctions.StartJobFunction)fn;
                    JobId jobId = ClusterControllerService.this.createJobId();
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new JobStartWork(ClusterControllerService.this, sjf.getDeploymentId(), sjf.getACGGFBytes(), sjf.getJobFlags(), jobId, (IResultCallback<JobId>)new IPCResponder(handle, mid)));
                    return;
                }
                case GET_DATASET_DIRECTORY_SERIVICE_INFO: {
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new GetDatasetDirectoryServiceInfoWork(ClusterControllerService.this, (IResultCallback<NetworkAddress>)new IPCResponder(handle, mid)));
                    return;
                }
                case GET_DATASET_RESULT_STATUS: {
                    HyracksClientInterfaceFunctions.GetDatasetResultStatusFunction gdrlf = (HyracksClientInterfaceFunctions.GetDatasetResultStatusFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new GetResultStatusWork(ClusterControllerService.this, gdrlf.getJobId(), gdrlf.getResultSetId(), (IResultCallback<DatasetJobRecord.Status>)new IPCResponder(handle, mid)));
                    return;
                }
                case GET_DATASET_RESULT_LOCATIONS: {
                    HyracksClientInterfaceFunctions.GetDatasetResultLocationsFunction gdrlf = (HyracksClientInterfaceFunctions.GetDatasetResultLocationsFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new GetResultPartitionLocationsWork(ClusterControllerService.this, gdrlf.getJobId(), gdrlf.getResultSetId(), gdrlf.getKnownRecords(), (IResultCallback<DatasetDirectoryRecord[]>)new IPCResponder(handle, mid)));
                    return;
                }
                case WAIT_FOR_COMPLETION: {
                    HyracksClientInterfaceFunctions.WaitForCompletionFunction wfcf = (HyracksClientInterfaceFunctions.WaitForCompletionFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new WaitForJobCompletionWork(ClusterControllerService.this, wfcf.getJobId(), (IResultCallback<Object>)new IPCResponder(handle, mid)));
                    return;
                }
                case GET_NODE_CONTROLLERS_INFO: {
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new GetNodeControllersInfoWork(ClusterControllerService.this, (IResultCallback<Map<String, NodeControllerInfo>>)new IPCResponder(handle, mid)));
                    return;
                }
                case GET_CLUSTER_TOPOLOGY: {
                    try {
                        handle.send(mid, (Object)ClusterControllerService.this.ccContext.getClusterTopology(), null);
                    }
                    catch (IPCException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                case CLI_DEPLOY_BINARY: {
                    HyracksClientInterfaceFunctions.CliDeployBinaryFunction dbf = (HyracksClientInterfaceFunctions.CliDeployBinaryFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new CliDeployBinaryWork(ClusterControllerService.this, dbf.getBinaryURLs(), dbf.getDeploymentId(), (IPCResponder<DeploymentId>)new IPCResponder(handle, mid)));
                    return;
                }
                case CLI_UNDEPLOY_BINARY: {
                    HyracksClientInterfaceFunctions.CliUnDeployBinaryFunction udbf = (HyracksClientInterfaceFunctions.CliUnDeployBinaryFunction)fn;
                    ClusterControllerService.this.workQueue.schedule((AbstractWork)new CliUnDeployBinaryWork(ClusterControllerService.this, udbf.getDeploymentId(), (IPCResponder<DeploymentId>)new IPCResponder(handle, mid)));
                    return;
                }
            }
            try {
                handle.send(mid, null, (Exception)new IllegalArgumentException("Unknown function " + fn.getFunctionId()));
            }
            catch (IPCException e) {
                e.printStackTrace();
            }
        }
    }

    private class DeadNodeSweeper
    extends TimerTask {
        private DeadNodeSweeper() {
        }

        @Override
        public void run() {
            ClusterControllerService.this.workQueue.schedule((AbstractWork)new RemoveDeadNodesWork(ClusterControllerService.this));
        }
    }
}

