/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.ipc.impl;

import edu.uci.ics.hyracks.ipc.api.IPayloadSerializerDeserializer;
import edu.uci.ics.hyracks.ipc.impl.IPCHandle;
import java.nio.ByteBuffer;

class Message {
    private static final int MSG_SIZE_SIZE = 4;
    private static final int HEADER_SIZE = 17;
    static final byte INITIAL_REQ = 1;
    static final byte INITIAL_ACK = 2;
    static final byte ERROR = 3;
    static final byte NORMAL = 0;
    private IPCHandle ipcHandle;
    private long messageId;
    private long requestMessageId;
    private byte flag;
    private Object payload;

    Message(IPCHandle ipcHandle) {
        this.ipcHandle = ipcHandle;
    }

    IPCHandle getIPCHandle() {
        return this.ipcHandle;
    }

    void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    long getMessageId() {
        return this.messageId;
    }

    void setRequestMessageId(long requestMessageId) {
        this.requestMessageId = requestMessageId;
    }

    long getRequestMessageId() {
        return this.requestMessageId;
    }

    void setFlag(byte flag) {
        this.flag = flag;
    }

    byte getFlag() {
        return this.flag;
    }

    void setPayload(Object payload) {
        this.payload = payload;
    }

    Object getPayload() {
        return this.payload;
    }

    static boolean hasMessage(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            return false;
        }
        int msgSize = buffer.getInt(buffer.position());
        return buffer.remaining() >= msgSize + 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(ByteBuffer buffer) throws Exception {
        assert (Message.hasMessage(buffer));
        int msgSize = buffer.getInt();
        this.messageId = buffer.getLong();
        this.requestMessageId = buffer.getLong();
        this.flag = buffer.get();
        int finalPosition = buffer.position() + msgSize - 17;
        int length = msgSize - 17;
        try {
            IPayloadSerializerDeserializer serde = this.ipcHandle.getIPCSystem().getSerializerDeserializer();
            this.payload = this.flag == 3 ? serde.deserializeException(buffer, length) : serde.deserializeObject(buffer, length);
        }
        finally {
            buffer.position(finalPosition);
        }
    }

    boolean write(ByteBuffer buffer) throws Exception {
        byte[] bytes;
        IPayloadSerializerDeserializer serde = this.ipcHandle.getIPCSystem().getSerializerDeserializer();
        byte[] byArray = bytes = this.flag == 3 ? serde.serializeException((Exception)this.payload) : serde.serializeObject(this.payload);
        if (buffer.remaining() >= 21 + bytes.length) {
            buffer.putInt(17 + bytes.length);
            buffer.putLong(this.messageId);
            buffer.putLong(this.requestMessageId);
            buffer.put(this.flag);
            buffer.put(bytes);
            return true;
        }
        return false;
    }

    public String toString() {
        return "MSG[" + this.messageId + ":" + this.requestMessageId + ":" + this.flag + ":" + this.payload + "]";
    }
}

