/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.ipc.impl;

import edu.uci.ics.hyracks.ipc.api.IIPCHandle;
import edu.uci.ics.hyracks.ipc.api.IIPCI;
import edu.uci.ics.hyracks.ipc.api.IPCPerformanceCounters;
import edu.uci.ics.hyracks.ipc.api.IPayloadSerializerDeserializer;
import edu.uci.ics.hyracks.ipc.exceptions.IPCException;
import edu.uci.ics.hyracks.ipc.impl.IPCConnectionManager;
import edu.uci.ics.hyracks.ipc.impl.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicLong;

public class IPCSystem {
    private final IPCConnectionManager cMgr;
    private final IIPCI ipci;
    private final IPayloadSerializerDeserializer serde;
    private final AtomicLong midFactory;
    private final IPCPerformanceCounters perfCounters;

    public IPCSystem(InetSocketAddress socketAddress, IIPCI ipci, IPayloadSerializerDeserializer serde) throws IOException {
        this.cMgr = new IPCConnectionManager(this, socketAddress);
        this.ipci = ipci;
        this.serde = serde;
        this.midFactory = new AtomicLong();
        this.perfCounters = new IPCPerformanceCounters();
    }

    public InetSocketAddress getSocketAddress() {
        return this.cMgr.getAddress();
    }

    public void start() {
        this.cMgr.start();
    }

    public IIPCHandle getHandle(InetSocketAddress remoteAddress) throws IPCException {
        try {
            return this.cMgr.getIPCHandle(remoteAddress);
        }
        catch (IOException e) {
            throw new IPCException(e);
        }
        catch (InterruptedException e) {
            throw new IPCException(e);
        }
    }

    IPayloadSerializerDeserializer getSerializerDeserializer() {
        return this.serde;
    }

    long createMessageId() {
        return this.midFactory.incrementAndGet();
    }

    void deliverIncomingMessage(Message message) {
        long mid = message.getMessageId();
        long rmid = message.getRequestMessageId();
        Object payload = null;
        Exception exception = null;
        if (message.getFlag() == 3) {
            exception = (Exception)message.getPayload();
        } else {
            payload = message.getPayload();
        }
        this.ipci.deliverIncomingMessage(message.getIPCHandle(), mid, rmid, payload, exception);
    }

    IPCConnectionManager getConnectionManager() {
        return this.cMgr;
    }

    public IPCPerformanceCounters getPerformanceCounters() {
        return this.perfCounters;
    }
}

