/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.ipc.impl;

import edu.uci.ics.hyracks.ipc.impl.HandleState;
import edu.uci.ics.hyracks.ipc.impl.IPCHandle;
import edu.uci.ics.hyracks.ipc.impl.IPCSystem;
import edu.uci.ics.hyracks.ipc.impl.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IPCConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(IPCConnectionManager.class.getName());
    private final IPCSystem system;
    private final NetworkThread networkThread;
    private final ServerSocketChannel serverSocketChannel;
    private final Map<InetSocketAddress, IPCHandle> ipcHandleMap;
    private final List<IPCHandle> pendingConnections;
    private final List<IPCHandle> workingPendingConnections;
    private final List<Message> sendList;
    private final List<Message> workingSendList;
    private final InetSocketAddress address;
    private volatile boolean stopped;

    IPCConnectionManager(IPCSystem system, InetSocketAddress socketAddress) throws IOException {
        this.system = system;
        this.networkThread = new NetworkThread();
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.socket().setReuseAddress(true);
        this.serverSocketChannel.configureBlocking(false);
        ServerSocket socket = this.serverSocketChannel.socket();
        socket.bind(socketAddress);
        this.address = new InetSocketAddress(socket.getInetAddress(), socket.getLocalPort());
        this.ipcHandleMap = new HashMap<InetSocketAddress, IPCHandle>();
        this.pendingConnections = new ArrayList<IPCHandle>();
        this.workingPendingConnections = new ArrayList<IPCHandle>();
        this.sendList = new ArrayList<Message>();
        this.workingSendList = new ArrayList<Message>();
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    void start() {
        this.stopped = false;
        this.networkThread.start();
    }

    void stop() throws IOException {
        this.stopped = true;
        this.serverSocketChannel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPCHandle getIPCHandle(InetSocketAddress remoteAddress) throws IOException, InterruptedException {
        IPCHandle handle;
        IPCConnectionManager iPCConnectionManager = this;
        synchronized (iPCConnectionManager) {
            handle = this.ipcHandleMap.get(remoteAddress);
            if (handle == null) {
                handle = new IPCHandle(this.system, remoteAddress);
                this.pendingConnections.add(handle);
                this.networkThread.selector.wakeup();
            }
        }
        handle.waitTillConnected();
        return handle;
    }

    synchronized void registerHandle(IPCHandle handle) {
        this.ipcHandleMap.put(handle.getRemoteAddress(), handle);
    }

    synchronized void write(Message msg) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Enqueued message: " + msg);
        }
        this.sendList.add(msg);
        this.networkThread.selector.wakeup();
    }

    private synchronized void collectOutstandingWork() {
        if (!this.pendingConnections.isEmpty()) {
            this.moveAll(this.pendingConnections, this.workingPendingConnections);
        }
        if (!this.sendList.isEmpty()) {
            this.moveAll(this.sendList, this.workingSendList);
        }
    }

    private Message createInitialReqMessage(IPCHandle handle) {
        Message msg = new Message(handle);
        msg.setMessageId(this.system.createMessageId());
        msg.setRequestMessageId(-1L);
        msg.setFlag((byte)1);
        msg.setPayload(this.address);
        return msg;
    }

    private Message createInitialAckMessage(IPCHandle handle, Message req) {
        Message msg = new Message(handle);
        msg.setMessageId(this.system.createMessageId());
        msg.setRequestMessageId(req.getMessageId());
        msg.setFlag((byte)2);
        msg.setPayload(null);
        return msg;
    }

    void ack(IPCHandle handle, Message req) {
        this.write(this.createInitialAckMessage(handle, req));
    }

    private <T> void moveAll(List<T> source, List<T> target) {
        int len = source.size();
        for (int i = 0; i < len; ++i) {
            target.add(source.get(i));
        }
        source.clear();
    }

    private class NetworkThread
    extends Thread {
        private final Selector selector;

        public NetworkThread() {
            super("IPC Network Listener Thread");
            this.setDaemon(true);
            try {
                this.selector = Selector.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            try {
                IPCConnectionManager.this.serverSocketChannel.register(this.selector, 16);
            }
            catch (ClosedChannelException e) {
                throw new RuntimeException(e);
            }
            BitSet unsentMessagesBitmap = new BitSet();
            ArrayList<Message> tempUnsentMessages = new ArrayList<Message>();
            while (!IPCConnectionManager.this.stopped) {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Starting Select");
                    }
                    int n = this.selector.select();
                    IPCConnectionManager.this.collectOutstandingWork();
                    if (!IPCConnectionManager.this.workingPendingConnections.isEmpty()) {
                        for (IPCHandle handle : IPCConnectionManager.this.workingPendingConnections) {
                            SocketChannel channel = SocketChannel.open();
                            channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                            channel.configureBlocking(false);
                            SelectionKey cKey = null;
                            if (channel.connect(handle.getRemoteAddress())) {
                                cKey = channel.register(this.selector, 1);
                                handle.setState(HandleState.CONNECT_SENT);
                                IPCConnectionManager.this.write(IPCConnectionManager.this.createInitialReqMessage(handle));
                            } else {
                                cKey = channel.register(this.selector, 8);
                            }
                            handle.setKey(cKey);
                            cKey.attach(handle);
                        }
                        IPCConnectionManager.this.workingPendingConnections.clear();
                    }
                    if (!IPCConnectionManager.this.workingSendList.isEmpty()) {
                        unsentMessagesBitmap.clear();
                        int len = IPCConnectionManager.this.workingSendList.size();
                        block6: for (int i = 0; i < len; ++i) {
                            IPCHandle handle;
                            Message msg = (Message)IPCConnectionManager.this.workingSendList.get(i);
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Processing send of message: " + msg);
                            }
                            if ((handle = msg.getIPCHandle()).getState() == HandleState.CLOSED) continue;
                            if (!handle.full()) {
                                while (true) {
                                    ByteBuffer buffer = handle.getOutBuffer();
                                    buffer.compact();
                                    boolean success = msg.write(buffer);
                                    buffer.flip();
                                    if (success) {
                                        IPCConnectionManager.this.system.getPerformanceCounters().addMessageSentCount(1L);
                                        SelectionKey key = handle.getKey();
                                        key.interestOps(key.interestOps() | 4);
                                        continue block6;
                                    }
                                    if (buffer.hasRemaining()) break;
                                    handle.resizeOutBuffer();
                                }
                                handle.markFull();
                                unsentMessagesBitmap.set(i);
                                continue;
                            }
                            unsentMessagesBitmap.set(i);
                        }
                        this.copyUnsentMessages(unsentMessagesBitmap, tempUnsentMessages);
                    }
                    if (n <= 0) continue;
                    Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                    while (i.hasNext()) {
                        int len;
                        IPCHandle handle;
                        SocketChannel channel;
                        SelectionKey key = i.next();
                        i.remove();
                        SelectableChannel sc = key.channel();
                        if (key.isReadable()) {
                            channel = (SocketChannel)sc;
                            handle = (IPCHandle)key.attachment();
                            ByteBuffer readBuffer = handle.getInBuffer();
                            len = channel.read(readBuffer);
                            IPCConnectionManager.this.system.getPerformanceCounters().addMessageBytesReceived(len);
                            if (len < 0) {
                                key.cancel();
                                channel.close();
                                handle.close();
                                continue;
                            }
                            handle.processIncomingMessages();
                            if (readBuffer.hasRemaining()) continue;
                            handle.resizeInBuffer();
                            continue;
                        }
                        if (key.isWritable()) {
                            channel = (SocketChannel)sc;
                            handle = (IPCHandle)key.attachment();
                            ByteBuffer writeBuffer = handle.getOutBuffer();
                            len = channel.write(writeBuffer);
                            IPCConnectionManager.this.system.getPerformanceCounters().addMessageBytesSent(len);
                            if (len < 0) {
                                key.cancel();
                                channel.close();
                                handle.close();
                            } else if (!writeBuffer.hasRemaining()) {
                                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                            }
                            if (!handle.full()) continue;
                            handle.clearFull();
                            this.selector.wakeup();
                            continue;
                        }
                        if (key.isAcceptable()) {
                            assert (sc == IPCConnectionManager.this.serverSocketChannel);
                            channel = IPCConnectionManager.this.serverSocketChannel.accept();
                            channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                            channel.configureBlocking(false);
                            handle = new IPCHandle(IPCConnectionManager.this.system, null);
                            SelectionKey cKey = channel.register(this.selector, 1);
                            handle.setKey(cKey);
                            cKey.attach(handle);
                            handle.setState(HandleState.CONNECT_RECEIVED);
                            continue;
                        }
                        if (!key.isConnectable() || !(channel = (SocketChannel)sc).finishConnect()) continue;
                        handle = (IPCHandle)key.attachment();
                        handle.setState(HandleState.CONNECT_SENT);
                        IPCConnectionManager.this.registerHandle(handle);
                        key.interestOps(1);
                        IPCConnectionManager.this.write(IPCConnectionManager.this.createInitialReqMessage(handle));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void copyUnsentMessages(BitSet unsentMessagesBitmap, List<Message> tempUnsentMessages) {
            assert (tempUnsentMessages.isEmpty());
            int i = unsentMessagesBitmap.nextSetBit(0);
            while (i >= 0) {
                tempUnsentMessages.add((Message)IPCConnectionManager.this.workingSendList.get(i));
                i = unsentMessagesBitmap.nextSetBit(i + 1);
            }
            IPCConnectionManager.this.workingSendList.clear();
            IPCConnectionManager.this.moveAll(tempUnsentMessages, IPCConnectionManager.this.workingSendList);
        }
    }
}

