/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.io;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.io.IFileHandle;
import edu.uci.ics.hyracks.api.io.IIOManager;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileReader;
import java.nio.ByteBuffer;

public class RunFileWriter
implements IFrameWriter {
    private final FileReference file;
    private final IIOManager ioManager;
    private boolean failed;
    private IFileHandle handle;
    private long size;

    public RunFileWriter(FileReference file, IIOManager ioManager) {
        this.file = file;
        this.ioManager = ioManager;
    }

    public void open() throws HyracksDataException {
        this.handle = this.ioManager.open(this.file, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
        this.size = 0L;
        this.failed = false;
    }

    public void fail() throws HyracksDataException {
        this.ioManager.close(this.handle);
        this.failed = true;
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.size += (long)this.ioManager.syncWrite(this.handle, this.size, buffer);
    }

    public void close() throws HyracksDataException {
        if (!this.failed) {
            this.ioManager.close(this.handle);
        }
    }

    public FileReference getFileReference() {
        return this.file;
    }

    public long getFileSize() {
        return this.size;
    }

    public RunFileReader createReader() throws HyracksDataException {
        if (this.failed) {
            throw new HyracksDataException("createReader() called on a failed RunFileWriter");
        }
        return new RunFileReader(this.file, this.ioManager, this.size);
    }
}

