/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.io;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.io.IFileHandle;
import edu.uci.ics.hyracks.api.io.IIOManager;
import java.nio.ByteBuffer;

public class RunFileReader
implements IFrameReader {
    private final FileReference file;
    private final IIOManager ioManager;
    private final long size;
    private IFileHandle handle;
    private long readPtr;

    public RunFileReader(FileReference file, IIOManager ioManager, long size) {
        this.file = file;
        this.ioManager = ioManager;
        this.size = size;
    }

    public void open() throws HyracksDataException {
        this.handle = this.ioManager.open(this.file, IIOManager.FileReadWriteMode.READ_ONLY, null);
        this.readPtr = 0L;
    }

    public boolean nextFrame(ByteBuffer buffer) throws HyracksDataException {
        buffer.clear();
        if (this.readPtr >= this.size) {
            return false;
        }
        this.readPtr += (long)this.ioManager.syncRead(this.handle, this.readPtr, buffer);
        return true;
    }

    public void close() throws HyracksDataException {
        this.ioManager.close(this.handle);
    }

    public long getFileSize() {
        return this.size;
    }
}

