/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.data.partition;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;

public class RepartitionComputerFactory
implements ITuplePartitionComputerFactory {
    private static final long serialVersionUID = 1L;
    private int factor;
    private ITuplePartitionComputerFactory delegateFactory;

    public RepartitionComputerFactory(int factor, ITuplePartitionComputerFactory delegate) {
        this.factor = factor;
        this.delegateFactory = delegate;
    }

    public ITuplePartitionComputer createPartitioner() {
        return new ITuplePartitionComputer(){
            private ITuplePartitionComputer delegate;
            {
                this.delegate = RepartitionComputerFactory.this.delegateFactory.createPartitioner();
            }

            public int partition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
                return this.delegate.partition(accessor, tIndex, RepartitionComputerFactory.this.factor * nParts) / RepartitionComputerFactory.this.factor;
            }
        };
    }
}

