/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.data.parsers;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.data.parsers.IValueParser;
import edu.uci.ics.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import java.io.DataOutput;
import java.io.IOException;

public class UTF8StringParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new UTF8StringParserFactory();
    private static final long serialVersionUID = 1L;

    private UTF8StringParserFactory() {
    }

    @Override
    public IValueParser createValueParser() {
        return new IValueParser(){
            private byte[] utf8;

            @Override
            public void parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                char ch;
                int utflen = 0;
                for (int i = 0; i < length; ++i) {
                    char ch2 = buffer[i + start];
                    if (ch2 >= '\u0001' && ch2 <= '\u007f') {
                        ++utflen;
                        continue;
                    }
                    if (ch2 > '\u07ff') {
                        utflen += 3;
                        continue;
                    }
                    utflen += 2;
                }
                if (this.utf8 == null || this.utf8.length < utflen + 2) {
                    this.utf8 = new byte[utflen + 2];
                }
                int count = 0;
                this.utf8[count++] = (byte)(utflen >>> 8 & 0xFF);
                this.utf8[count++] = (byte)(utflen >>> 0 & 0xFF);
                int i = 0;
                for (i = 0; i < length && (ch = buffer[i + start]) >= '\u0001' && ch <= '\u007f'; ++i) {
                    this.utf8[count++] = (byte)ch;
                }
                while (i < length) {
                    ch = buffer[i + start];
                    if (ch >= '\u0001' && ch <= '\u007f') {
                        this.utf8[count++] = (byte)ch;
                    } else if (ch > '\u07ff') {
                        this.utf8[count++] = (byte)(0xE0 | ch >> 12 & 0xF);
                        this.utf8[count++] = (byte)(0x80 | ch >> 6 & 0x3F);
                        this.utf8[count++] = (byte)(0x80 | ch >> 0 & 0x3F);
                    } else {
                        this.utf8[count++] = (byte)(0xC0 | ch >> 6 & 0x1F);
                        this.utf8[count++] = (byte)(0x80 | ch >> 0 & 0x3F);
                    }
                    ++i;
                }
                try {
                    out.write(this.utf8, 0, utflen + 2);
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        };
    }
}

