/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.data.parsers;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.data.parsers.IValueParser;
import edu.uci.ics.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import java.io.DataOutput;
import java.io.IOException;

public class FloatParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new FloatParserFactory();
    private static final long serialVersionUID = 1L;

    private FloatParserFactory() {
    }

    @Override
    public IValueParser createValueParser() {
        return new IValueParser(){

            @Override
            public void parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                String s = String.valueOf(buffer, start, length);
                try {
                    out.writeFloat(Float.parseFloat(s));
                }
                catch (NumberFormatException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        };
    }
}

