/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.data.normalizers;

import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;

public class UTF8StringNormalizedKeyComputerFactory
implements INormalizedKeyComputerFactory {
    private static final long serialVersionUID = 1L;

    public INormalizedKeyComputer createNormalizedKeyComputer() {
        return new INormalizedKeyComputer(){

            public int normalize(byte[] bytes, int start, int length) {
                int len = UTF8StringPointable.getUTFLength((byte[])bytes, (int)start);
                int nk = 0;
                int offset = start + 2;
                for (int i = 0; i < 2; ++i) {
                    nk <<= 16;
                    if (i >= len) continue;
                    nk += UTF8StringPointable.charAt((byte[])bytes, (int)offset) & 0xFFFF;
                    offset += UTF8StringPointable.charSize((byte[])bytes, (int)offset);
                }
                return nk;
            }
        };
    }
}

