/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.data.normalizers;

import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.Integer64SerializerDeserializer;

public class Integer64NormalizedKeyComputerFactory
implements INormalizedKeyComputerFactory {
    private static final long serialVersionUID = 8735044913496854551L;

    public INormalizedKeyComputer createNormalizedKeyComputer() {
        return new INormalizedKeyComputer(){
            private static final int POSTIVE_LONG_MASK = -1073741824;
            private static final int NON_NEGATIVE_INT_MASK = Integer.MIN_VALUE;
            private static final int NEGATIVE_LONG_MASK = 0;

            public int normalize(byte[] bytes, int start, int length) {
                long value = Integer64SerializerDeserializer.getLong(bytes, start);
                int highValue = (int)(value >> 32);
                if (highValue > 0) {
                    int highNmk = this.getKey(highValue);
                    highNmk >>= 2;
                    return highNmk |= 0xC0000000;
                }
                if (highValue == 0) {
                    int lowNmk = (int)value;
                    lowNmk >>= 2;
                    return lowNmk |= Integer.MIN_VALUE;
                }
                int highNmk = this.getKey(highValue);
                highNmk >>= 2;
                return highNmk |= 0;
            }

            private int getKey(int value) {
                return value ^ Integer.MIN_VALUE;
            }
        };
    }
}

