/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.data.marshalling;

import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ShortSerializerDeserializer
implements ISerializerDeserializer<Short> {
    private static final long serialVersionUID = 1L;
    public static final ShortSerializerDeserializer INSTANCE = new ShortSerializerDeserializer();

    private ShortSerializerDeserializer() {
    }

    public Short deserialize(DataInput in) throws HyracksDataException {
        try {
            return in.readShort();
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(Short instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeShort(instance.intValue());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public static short getShort(byte[] bytes, int offset) {
        return (short)(((bytes[offset] & 0xFF) << 8) + (bytes[offset + 1] & 0xFF));
    }

    public static void putShort(int val, byte[] bytes, int offset) {
        bytes[offset] = (byte)(val >>> 8 & 0xFF);
        bytes[offset + 1] = (byte)(val >>> 0 & 0xFF);
    }
}

