/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.data.marshalling;

import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntegerSerializerDeserializer
implements ISerializerDeserializer<Integer> {
    private static final long serialVersionUID = 1L;
    public static final IntegerSerializerDeserializer INSTANCE = new IntegerSerializerDeserializer();

    private IntegerSerializerDeserializer() {
    }

    public Integer deserialize(DataInput in) throws HyracksDataException {
        try {
            return in.readInt();
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(Integer instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeInt(instance);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public static int getInt(byte[] bytes, int offset) {
        return ((bytes[offset] & 0xFF) << 24) + ((bytes[offset + 1] & 0xFF) << 16) + ((bytes[offset + 2] & 0xFF) << 8) + ((bytes[offset + 3] & 0xFF) << 0);
    }

    public static void putInt(int val, byte[] bytes, int offset) {
        bytes[offset] = (byte)(val >>> 24 & 0xFF);
        bytes[offset + 1] = (byte)(val >>> 16 & 0xFF);
        bytes[offset + 2] = (byte)(val >>> 8 & 0xFF);
        bytes[offset + 3] = (byte)(val >>> 0 & 0xFF);
    }
}

