/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.data.marshalling;

import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FloatSerializerDeserializer
implements ISerializerDeserializer<Float> {
    private static final long serialVersionUID = 1L;
    public static final FloatSerializerDeserializer INSTANCE = new FloatSerializerDeserializer();

    private FloatSerializerDeserializer() {
    }

    public Float deserialize(DataInput in) throws HyracksDataException {
        try {
            return Float.valueOf(in.readFloat());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(Float instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeFloat(instance.floatValue());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public static float getFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(FloatSerializerDeserializer.getIntBits(bytes, offset));
    }

    public static int getIntBits(byte[] bytes, int offset) {
        return IntegerSerializerDeserializer.getInt(bytes, offset);
    }
}

