/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.data.marshalling;

import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.Integer64SerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DoubleSerializerDeserializer
implements ISerializerDeserializer<Double> {
    private static final long serialVersionUID = 1L;
    public static final DoubleSerializerDeserializer INSTANCE = new DoubleSerializerDeserializer();

    private DoubleSerializerDeserializer() {
    }

    public Double deserialize(DataInput in) throws HyracksDataException {
        try {
            return in.readDouble();
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(Double instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeDouble(instance);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public static double getDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(DoubleSerializerDeserializer.getLongBits(bytes, offset));
    }

    public static int getIntBits(byte[] bytes, int offset) {
        return IntegerSerializerDeserializer.getInt(bytes, offset);
    }

    public static long getLongBits(byte[] bytes, int offset) {
        return Integer64SerializerDeserializer.getLong(bytes, offset);
    }
}

