/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.comm.util;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import java.nio.ByteBuffer;

public class FrameUtils {
    public static void copy(ByteBuffer srcFrame, ByteBuffer destFrame) {
        FrameUtils.makeReadable(srcFrame);
        destFrame.clear();
        destFrame.put(srcFrame);
    }

    public static void makeReadable(ByteBuffer frame) {
        frame.position(0);
        frame.limit(frame.capacity());
    }

    public static void flushFrame(ByteBuffer buffer, IFrameWriter writer) throws HyracksDataException {
        buffer.position(0);
        buffer.limit(buffer.capacity());
        writer.nextFrame(buffer);
        buffer.position(0);
        buffer.limit(buffer.capacity());
    }

    public static int getAbsoluteFieldStartOffset(IFrameTupleAccessor accessor, int tuple, int field) {
        return accessor.getTupleStartOffset(tuple) + accessor.getFieldSlotsLength() + accessor.getFieldStartOffset(tuple, field);
    }
}

