/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.comm.util;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteBufferInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger(ByteBufferInputStream.class.getName());
    private ByteBuffer buffer;
    private int position;

    public void setByteBuffer(ByteBuffer buffer, int position) {
        this.buffer = buffer;
        this.position = position;
    }

    @Override
    public int read() {
        int value;
        int remaining = this.buffer.capacity() - this.position;
        int n = value = remaining > 0 ? this.buffer.get(this.position++) & 0xFF : -1;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("read(): value: " + value + " remaining: " + remaining + " position: " + this.position);
        }
        return value;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) {
        int remaining = this.buffer.capacity() - this.position;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("read(bytes[], int, int): remaining: " + remaining + " offset: " + offset + " length: " + length + " position: " + this.position);
        }
        if (remaining == 0) {
            return -1;
        }
        int l = Math.min(length, remaining);
        System.arraycopy(this.buffer.array(), this.position, bytes, offset, l);
        this.position += l;
        return l;
    }
}

