/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.comm.io;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOpenableDataWriter;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerializingDataWriter
implements IOpenableDataWriter<Object[]> {
    private static final Logger LOGGER = Logger.getLogger(SerializingDataWriter.class.getName());
    private final ByteBuffer buffer;
    private final ArrayTupleBuilder tb;
    private final RecordDescriptor recordDescriptor;
    private final IFrameWriter frameWriter;
    private final FrameTupleAppender tupleAppender;
    private boolean open;

    public SerializingDataWriter(IHyracksTaskContext ctx, RecordDescriptor recordDescriptor, IFrameWriter frameWriter) throws HyracksDataException {
        this.buffer = ctx.allocateFrame();
        this.tb = new ArrayTupleBuilder(recordDescriptor.getFieldCount());
        this.recordDescriptor = recordDescriptor;
        this.frameWriter = frameWriter;
        this.tupleAppender = new FrameTupleAppender(ctx.getFrameSize());
        this.open = false;
    }

    public void open() throws HyracksDataException {
        this.frameWriter.open();
        this.buffer.clear();
        this.open = true;
        this.tupleAppender.reset(this.buffer, true);
    }

    public void close() throws HyracksDataException {
        if (!this.open) {
            throw new HyracksDataException("Closing SerializingDataWriter that has not been opened");
        }
        if (this.tupleAppender.getTupleCount() > 0) {
            this.flushFrame();
        }
        this.frameWriter.close();
        this.open = false;
    }

    public void writeData(Object[] data) throws HyracksDataException {
        if (!this.open) {
            throw new HyracksDataException("Writing to SerializingDataWriter that has not been opened");
        }
        this.tb.reset();
        for (int i = 0; i < data.length; ++i) {
            Object instance = data[i];
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(i + " " + instance);
            }
            this.tb.addField(this.recordDescriptor.getFields()[i], instance);
        }
        if (!this.tupleAppender.append(this.tb.getFieldEndOffsets(), this.tb.getByteArray(), 0, this.tb.getSize())) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Flushing: position = " + this.buffer.position());
            }
            this.flushFrame();
            this.tupleAppender.reset(this.buffer, true);
            if (!this.tupleAppender.append(this.tb.getFieldEndOffsets(), this.tb.getByteArray(), 0, this.tb.getSize())) {
                throw new HyracksDataException("Record size (" + this.tb.getSize() + ") larger than frame size (" + this.buffer.capacity() + ")");
            }
        }
    }

    private void flushFrame() throws HyracksDataException {
        this.buffer.position(0);
        this.buffer.limit(this.buffer.capacity());
        this.frameWriter.nextFrame(this.buffer);
    }

    public void fail() throws HyracksDataException {
        this.frameWriter.fail();
    }
}

