/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.comm.io;

import edu.uci.ics.hyracks.api.comm.FrameHelper;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.util.ByteBufferInputStream;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class ResultFrameTupleAccessor
implements IFrameTupleAccessor {
    private final int frameSize;
    private ByteBuffer buffer;

    public ResultFrameTupleAccessor(int frameSize) {
        this.frameSize = frameSize;
    }

    public void reset(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getTupleCount() {
        return this.buffer.getInt(FrameHelper.getTupleCountOffset((int)this.frameSize));
    }

    public int getTupleStartOffset(int tupleIndex) {
        return tupleIndex == 0 ? 0 : this.buffer.getInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * tupleIndex);
    }

    public int getTupleEndOffset(int tupleIndex) {
        return this.buffer.getInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (tupleIndex + 1));
    }

    public int getFieldStartOffset(int tupleIndex, int fIdx) {
        return fIdx == 0 ? 0 : this.buffer.getInt(this.getTupleStartOffset(tupleIndex) + (fIdx - 1) * 4);
    }

    public int getFieldEndOffset(int tupleIndex, int fIdx) {
        return this.buffer.getInt(this.getTupleStartOffset(tupleIndex) + fIdx * 4);
    }

    public int getFieldLength(int tupleIndex, int fIdx) {
        return this.getFieldEndOffset(tupleIndex, fIdx) - this.getFieldStartOffset(tupleIndex, fIdx);
    }

    public int getFieldSlotsLength() {
        return this.getFieldCount() * 4;
    }

    public void prettyPrint() {
        ByteBufferInputStream bbis = new ByteBufferInputStream();
        DataInputStream dis = new DataInputStream(bbis);
        int tc = this.getTupleCount();
        System.err.println("TC: " + tc);
        for (int i = 0; i < tc; ++i) {
            System.err.print(i + ":(" + this.getTupleStartOffset(i) + ", " + this.getTupleEndOffset(i) + ")[");
            bbis.setByteBuffer(this.buffer, this.getTupleStartOffset(i));
            System.err.print(dis);
            System.err.println("]");
        }
    }

    public int getFieldCount() {
        return 1;
    }
}

