/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.comm.io;

import edu.uci.ics.hyracks.api.comm.FrameHelper;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import java.nio.ByteBuffer;

public class FrameTupleAppender {
    private final int frameSize;
    private ByteBuffer buffer;
    private int tupleCount;
    private int tupleDataEndOffset;
    private int numberOfFields = -1;
    private int currentField = 0;
    private int lastFieldEndOffset = 0;

    public FrameTupleAppender(int frameSize) {
        this.frameSize = frameSize;
    }

    public FrameTupleAppender(int frameSize, int numberOfFields) {
        this.frameSize = frameSize;
        this.numberOfFields = numberOfFields;
    }

    public void reset(ByteBuffer buffer, boolean clear) {
        this.buffer = buffer;
        if (clear) {
            buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), 0);
            this.tupleCount = 0;
            this.tupleDataEndOffset = 0;
        } else {
            this.tupleCount = buffer.getInt(FrameHelper.getTupleCountOffset((int)this.frameSize));
            this.tupleDataEndOffset = this.tupleCount == 0 ? 0 : buffer.getInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - this.tupleCount * 4);
        }
    }

    public boolean append(int[] fieldSlots, byte[] bytes, int offset, int length) {
        if (this.tupleDataEndOffset + fieldSlots.length * 4 + length + 4 + (this.tupleCount + 1) * 4 <= this.frameSize) {
            for (int i = 0; i < fieldSlots.length; ++i) {
                this.buffer.putInt(this.tupleDataEndOffset + i * 4, fieldSlots[i]);
            }
            System.arraycopy(bytes, offset, this.buffer.array(), this.tupleDataEndOffset + fieldSlots.length * 4, length);
            this.tupleDataEndOffset += fieldSlots.length * 4 + length;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (this.tupleCount + 1), this.tupleDataEndOffset);
            ++this.tupleCount;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean append(byte[] bytes, int offset, int length) {
        if (this.tupleDataEndOffset + length + 4 + (this.tupleCount + 1) * 4 <= this.frameSize) {
            System.arraycopy(bytes, offset, this.buffer.array(), this.tupleDataEndOffset, length);
            this.tupleDataEndOffset += length;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (this.tupleCount + 1), this.tupleDataEndOffset);
            ++this.tupleCount;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean appendSkipEmptyField(int[] fieldSlots, byte[] bytes, int offset, int length) {
        if (this.tupleDataEndOffset + fieldSlots.length * 4 + length + 4 + (this.tupleCount + 1) * 4 <= this.frameSize) {
            int effectiveSlots = 0;
            for (int i = 0; i < fieldSlots.length; ++i) {
                if (fieldSlots[i] <= 0) continue;
                this.buffer.putInt(this.tupleDataEndOffset + i * 4, fieldSlots[i]);
                ++effectiveSlots;
            }
            System.arraycopy(bytes, offset, this.buffer.array(), this.tupleDataEndOffset + effectiveSlots * 4, length);
            this.tupleDataEndOffset += effectiveSlots * 4 + length;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (this.tupleCount + 1), this.tupleDataEndOffset);
            ++this.tupleCount;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean appendField(byte[] bytes, int offset, int length) {
        if (this.numberOfFields < 0) {
            throw new IllegalStateException("unintialized number of fields " + this.numberOfFields);
        }
        int currentTupleDataStart = this.tupleDataEndOffset + this.numberOfFields * 4 + this.lastFieldEndOffset;
        if (currentTupleDataStart + length + 4 + (this.tupleCount + 1) * 4 <= this.frameSize) {
            System.arraycopy(bytes, offset, this.buffer.array(), currentTupleDataStart, length);
            this.lastFieldEndOffset += length;
            this.buffer.putInt(this.tupleDataEndOffset + this.currentField * 4, this.lastFieldEndOffset);
            if (++this.currentField == this.numberOfFields) {
                this.tupleDataEndOffset += this.numberOfFields * 4 + this.lastFieldEndOffset;
                this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (this.tupleCount + 1), this.tupleDataEndOffset);
                ++this.tupleCount;
                this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), this.tupleCount);
                this.currentField = 0;
                this.lastFieldEndOffset = 0;
            }
            return true;
        }
        this.currentField = 0;
        this.lastFieldEndOffset = 0;
        return false;
    }

    public boolean appendField(IFrameTupleAccessor fta, int tIndex, int fIndex) {
        if (this.numberOfFields < 0) {
            throw new IllegalStateException("unintialized number of fields " + this.numberOfFields);
        }
        int startOffset = fta.getTupleStartOffset(tIndex);
        int fStartOffset = fta.getFieldStartOffset(tIndex, fIndex);
        int fLen = fta.getFieldEndOffset(tIndex, fIndex) - fStartOffset;
        return this.appendField(fta.getBuffer().array(), startOffset + fta.getFieldSlotsLength() + fStartOffset, fLen);
    }

    public boolean append(IFrameTupleAccessor tupleAccessor, int tStartOffset, int tEndOffset) {
        int length = tEndOffset - tStartOffset;
        if (this.tupleDataEndOffset + length + 4 + (this.tupleCount + 1) * 4 <= this.frameSize) {
            ByteBuffer src = tupleAccessor.getBuffer();
            System.arraycopy(src.array(), tStartOffset, this.buffer.array(), this.tupleDataEndOffset, length);
            this.tupleDataEndOffset += length;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (this.tupleCount + 1), this.tupleDataEndOffset);
            ++this.tupleCount;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean append(IFrameTupleAccessor tupleAccessor, int tIndex) {
        int tStartOffset = tupleAccessor.getTupleStartOffset(tIndex);
        int tEndOffset = tupleAccessor.getTupleEndOffset(tIndex);
        return this.append(tupleAccessor, tStartOffset, tEndOffset);
    }

    public boolean appendConcat(IFrameTupleAccessor accessor0, int tIndex0, IFrameTupleAccessor accessor1, int tIndex1) {
        int startOffset0 = accessor0.getTupleStartOffset(tIndex0);
        int endOffset0 = accessor0.getTupleEndOffset(tIndex0);
        int length0 = endOffset0 - startOffset0;
        int startOffset1 = accessor1.getTupleStartOffset(tIndex1);
        int endOffset1 = accessor1.getTupleEndOffset(tIndex1);
        int length1 = endOffset1 - startOffset1;
        if (this.tupleDataEndOffset + length0 + length1 + 4 + (this.tupleCount + 1) * 4 <= this.frameSize) {
            ByteBuffer src0 = accessor0.getBuffer();
            ByteBuffer src1 = accessor1.getBuffer();
            int slotsLen0 = accessor0.getFieldSlotsLength();
            int slotsLen1 = accessor1.getFieldSlotsLength();
            int dataLen0 = length0 - slotsLen0;
            int dataLen1 = length1 - slotsLen1;
            System.arraycopy(src0.array(), startOffset0, this.buffer.array(), this.tupleDataEndOffset, slotsLen0);
            for (int i = 0; i < slotsLen1 / 4; ++i) {
                this.buffer.putInt(this.tupleDataEndOffset + slotsLen0 + i * 4, src1.getInt(startOffset1 + i * 4) + dataLen0);
            }
            System.arraycopy(src0.array(), startOffset0 + slotsLen0, this.buffer.array(), this.tupleDataEndOffset + slotsLen0 + slotsLen1, dataLen0);
            System.arraycopy(src1.array(), startOffset1 + slotsLen1, this.buffer.array(), this.tupleDataEndOffset + slotsLen0 + slotsLen1 + dataLen0, dataLen1);
            this.tupleDataEndOffset += length0 + length1;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (this.tupleCount + 1), this.tupleDataEndOffset);
            ++this.tupleCount;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean appendConcat(IFrameTupleAccessor accessor0, int tIndex0, int[] fieldSlots1, byte[] bytes1, int offset1, int dataLen1) {
        int slotsLen1;
        int length1;
        int startOffset0 = accessor0.getTupleStartOffset(tIndex0);
        int endOffset0 = accessor0.getTupleEndOffset(tIndex0);
        int length0 = endOffset0 - startOffset0;
        if (this.tupleDataEndOffset + length0 + (length1 = (slotsLen1 = fieldSlots1.length * 4) + dataLen1) + 4 + (this.tupleCount + 1) * 4 <= this.frameSize) {
            ByteBuffer src0 = accessor0.getBuffer();
            int slotsLen0 = accessor0.getFieldSlotsLength();
            int dataLen0 = length0 - slotsLen0;
            System.arraycopy(src0.array(), startOffset0, this.buffer.array(), this.tupleDataEndOffset, slotsLen0);
            for (int i = 0; i < fieldSlots1.length; ++i) {
                this.buffer.putInt(this.tupleDataEndOffset + slotsLen0 + i * 4, fieldSlots1[i] + dataLen0);
            }
            System.arraycopy(src0.array(), startOffset0 + slotsLen0, this.buffer.array(), this.tupleDataEndOffset + slotsLen0 + slotsLen1, dataLen0);
            System.arraycopy(bytes1, offset1, this.buffer.array(), this.tupleDataEndOffset + slotsLen0 + fieldSlots1.length * 4 + dataLen0, dataLen1);
            this.tupleDataEndOffset += length0 + length1;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (this.tupleCount + 1), this.tupleDataEndOffset);
            ++this.tupleCount;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean appendConcat(int[] fieldSlots0, byte[] bytes0, int offset0, int dataLen0, IFrameTupleAccessor accessor1, int tIndex1) {
        int slotsLen0 = fieldSlots0.length * 4;
        int length0 = slotsLen0 + dataLen0;
        int startOffset1 = accessor1.getTupleStartOffset(tIndex1);
        int endOffset1 = accessor1.getTupleEndOffset(tIndex1);
        int length1 = endOffset1 - startOffset1;
        if (this.tupleDataEndOffset + length0 + length1 + 4 + (this.tupleCount + 1) * 4 <= this.frameSize) {
            int i;
            ByteBuffer src1 = accessor1.getBuffer();
            int slotsLen1 = accessor1.getFieldSlotsLength();
            int dataLen1 = length1 - slotsLen1;
            for (i = 0; i < fieldSlots0.length; ++i) {
                this.buffer.putInt(this.tupleDataEndOffset + i * 4, fieldSlots0[i]);
            }
            for (i = 0; i < slotsLen1 / 4; ++i) {
                this.buffer.putInt(this.tupleDataEndOffset + slotsLen0 + i * 4, src1.getInt(startOffset1 + i * 4) + dataLen0);
            }
            System.arraycopy(bytes0, offset0, this.buffer.array(), this.tupleDataEndOffset + slotsLen0 + slotsLen1, dataLen0);
            System.arraycopy(src1.array(), startOffset1 + slotsLen1, this.buffer.array(), this.tupleDataEndOffset + slotsLen0 + slotsLen1 + dataLen0, dataLen1);
            this.tupleDataEndOffset += length0 + length1;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (this.tupleCount + 1), this.tupleDataEndOffset);
            ++this.tupleCount;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean appendProjection(IFrameTupleAccessor accessor, int tIndex, int[] fields) {
        int fTargetSlotsLength;
        int length = fTargetSlotsLength = fields.length * 4;
        for (int i = 0; i < fields.length; ++i) {
            length += accessor.getFieldEndOffset(tIndex, fields[i]) - accessor.getFieldStartOffset(tIndex, fields[i]);
        }
        if (this.tupleDataEndOffset + length + 4 + (this.tupleCount + 1) * 4 <= this.frameSize) {
            int fSrcSlotsLength = accessor.getFieldSlotsLength();
            int tStartOffset = accessor.getTupleStartOffset(tIndex);
            int fStartOffset = 0;
            int fEndOffset = 0;
            for (int i = 0; i < fields.length; ++i) {
                int fSrcStart = tStartOffset + fSrcSlotsLength + accessor.getFieldStartOffset(tIndex, fields[i]);
                int fLen = accessor.getFieldEndOffset(tIndex, fields[i]) - accessor.getFieldStartOffset(tIndex, fields[i]);
                System.arraycopy(accessor.getBuffer().array(), fSrcStart, this.buffer.array(), this.tupleDataEndOffset + fTargetSlotsLength + fStartOffset, fLen);
                this.buffer.putInt(this.tupleDataEndOffset + i * 4, fEndOffset += fLen);
                fStartOffset = fEndOffset;
            }
            this.tupleDataEndOffset += length;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (this.tupleCount + 1), this.tupleDataEndOffset);
            ++this.tupleCount;
            this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), this.tupleCount);
            return true;
        }
        return false;
    }

    public int getTupleCount() {
        return this.tupleCount;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

