/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.comm.io;

import edu.uci.ics.hyracks.api.comm.FrameHelper;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.util.ByteBufferInputStream;
import edu.uci.ics.hyracks.dataflow.common.util.IntSerDeUtils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class FrameTupleAccessor
implements IFrameTupleAccessor {
    private final int frameSize;
    private final RecordDescriptor recordDescriptor;
    private ByteBuffer buffer;

    public FrameTupleAccessor(int frameSize, RecordDescriptor recordDescriptor) {
        this.frameSize = frameSize;
        this.recordDescriptor = recordDescriptor;
    }

    public void reset(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getTupleCount() {
        return IntSerDeUtils.getInt(this.buffer.array(), FrameHelper.getTupleCountOffset((int)this.frameSize));
    }

    public int getTupleStartOffset(int tupleIndex) {
        return tupleIndex == 0 ? 0 : IntSerDeUtils.getInt(this.buffer.array(), FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * tupleIndex);
    }

    public int getTupleEndOffset(int tupleIndex) {
        return IntSerDeUtils.getInt(this.buffer.array(), FrameHelper.getTupleCountOffset((int)this.frameSize) - 4 * (tupleIndex + 1));
    }

    public int getFieldStartOffset(int tupleIndex, int fIdx) {
        return fIdx == 0 ? 0 : IntSerDeUtils.getInt(this.buffer.array(), this.getTupleStartOffset(tupleIndex) + (fIdx - 1) * 4);
    }

    public int getFieldEndOffset(int tupleIndex, int fIdx) {
        return IntSerDeUtils.getInt(this.buffer.array(), this.getTupleStartOffset(tupleIndex) + fIdx * 4);
    }

    public int getFieldLength(int tupleIndex, int fIdx) {
        return this.getFieldEndOffset(tupleIndex, fIdx) - this.getFieldStartOffset(tupleIndex, fIdx);
    }

    public int getFieldSlotsLength() {
        return this.getFieldCount() * 4;
    }

    public void prettyPrint() {
        ByteBufferInputStream bbis = new ByteBufferInputStream();
        DataInputStream dis = new DataInputStream(bbis);
        int tc = this.getTupleCount();
        System.err.println("TC: " + tc);
        for (int i = 0; i < tc; ++i) {
            System.err.print(i + ":(" + this.getTupleStartOffset(i) + ", " + this.getTupleEndOffset(i) + ")[");
            for (int j = 0; j < this.getFieldCount(); ++j) {
                System.err.print(j + ":(" + this.getFieldStartOffset(i, j) + ", " + this.getFieldEndOffset(i, j) + ") ");
                System.err.print("{");
                bbis.setByteBuffer(this.buffer, this.getTupleStartOffset(i) + this.getFieldSlotsLength() + this.getFieldStartOffset(i, j));
                try {
                    System.err.print(this.recordDescriptor.getFields()[j].deserialize((DataInput)dis));
                }
                catch (HyracksDataException e) {
                    e.printStackTrace();
                }
                System.err.print("}");
            }
            System.err.println("]");
        }
    }

    public int getFieldCount() {
        return this.recordDescriptor.getFieldCount();
    }
}

