/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.comm.io;

import edu.uci.ics.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FrameOutputStream
extends ByteArrayAccessibleOutputStream {
    private static final Logger LOGGER = Logger.getLogger(FrameOutputStream.class.getName());
    private final FrameTupleAppender frameTupleAppender;

    public FrameOutputStream(int frameSize) {
        super(frameSize);
        this.frameTupleAppender = new FrameTupleAppender(frameSize);
    }

    public void reset(ByteBuffer buffer, boolean clear) {
        if (clear) {
            buffer.clear();
        }
        this.frameTupleAppender.reset(buffer, clear);
    }

    public int getTupleCount() {
        int tupleCount = this.frameTupleAppender.getTupleCount();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("appendTuple(): tuple count: " + tupleCount);
        }
        return tupleCount;
    }

    public boolean appendTuple() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("appendTuple(): tuple size: " + this.count);
        }
        boolean appended = this.frameTupleAppender.append(this.buf, 0, this.count);
        this.count = 0;
        return appended;
    }
}

