/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.comm.io;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOpenableDataWriter;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameDeserializer;
import java.nio.ByteBuffer;

public class FrameDeserializingDataWriter
implements IFrameWriter {
    private final IOpenableDataWriter<Object[]> writer;
    private final FrameDeserializer frameDeserializer;

    public FrameDeserializingDataWriter(IHyracksTaskContext ctx, IOpenableDataWriter<Object[]> writer, RecordDescriptor recordDescriptor) {
        this.writer = writer;
        this.frameDeserializer = new FrameDeserializer(ctx.getFrameSize(), recordDescriptor);
    }

    public void close() throws HyracksDataException {
        this.writer.close();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.frameDeserializer.reset(buffer);
        while (!this.frameDeserializer.done()) {
            Object[] tuple = this.frameDeserializer.deserializeRecord();
            this.writer.writeData((Object)tuple);
        }
    }

    public void open() throws HyracksDataException {
        this.writer.open();
    }

    public void fail() {
    }
}

