/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.comm.io;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOpenableDataReader;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameDeserializer;
import java.nio.ByteBuffer;

public class FrameDeserializingDataReader
implements IOpenableDataReader<Object[]> {
    private final ByteBuffer buffer;
    private boolean eos;
    private boolean first;
    private final IFrameReader frameReader;
    private final FrameDeserializer frameDeserializer;

    public FrameDeserializingDataReader(IHyracksTaskContext ctx, IFrameReader frameReader, RecordDescriptor recordDescriptor) throws HyracksDataException {
        this.buffer = ctx.allocateFrame();
        this.frameReader = frameReader;
        this.frameDeserializer = new FrameDeserializer(ctx.getFrameSize(), recordDescriptor);
    }

    public void open() throws HyracksDataException {
        this.frameReader.open();
        this.buffer.clear();
        this.buffer.flip();
        this.eos = false;
        this.first = true;
    }

    public void close() throws HyracksDataException {
        this.frameReader.close();
        this.frameDeserializer.close();
    }

    public Object[] readData() throws HyracksDataException {
        while (!this.eos) {
            if (!this.first && !this.frameDeserializer.done()) {
                return this.frameDeserializer.deserializeRecord();
            }
            this.buffer.clear();
            if (!this.frameReader.nextFrame(this.buffer)) {
                this.eos = true;
            } else {
                this.frameDeserializer.reset(this.buffer);
            }
            this.first = false;
        }
        return null;
    }
}

