/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.common.comm.io;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.data.std.api.IDataOutputProvider;
import edu.uci.ics.hyracks.data.std.util.GrowableArray;
import java.io.DataOutput;
import java.io.IOException;

public class ArrayTupleBuilder
implements IDataOutputProvider {
    private final GrowableArray fieldData = new GrowableArray();
    private final int[] fEndOffsets;
    private int nextField;

    public ArrayTupleBuilder(int nFields) {
        this.fEndOffsets = new int[nFields];
    }

    public void reset() {
        this.nextField = 0;
        this.fieldData.reset();
    }

    public int[] getFieldEndOffsets() {
        return this.fEndOffsets;
    }

    public byte[] getByteArray() {
        return this.fieldData.getByteArray();
    }

    public int getSize() {
        return this.fieldData.getLength();
    }

    public void addField(IFrameTupleAccessor accessor, int tIndex, int fIndex) throws HyracksDataException {
        int startOffset = accessor.getTupleStartOffset(tIndex);
        int fStartOffset = accessor.getFieldStartOffset(tIndex, fIndex);
        int fLen = accessor.getFieldEndOffset(tIndex, fIndex) - fStartOffset;
        try {
            this.fieldData.getDataOutput().write(accessor.getBuffer().array(), startOffset + accessor.getFieldSlotsLength() + fStartOffset, fLen);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        this.fEndOffsets[this.nextField++] = this.fieldData.getLength();
    }

    public <T> void addField(ISerializerDeserializer<T> serDeser, T instance) throws HyracksDataException {
        serDeser.serialize(instance, this.fieldData.getDataOutput());
        this.fEndOffsets[this.nextField++] = this.fieldData.getLength();
    }

    public void addField(byte[] bytes, int start, int length) throws HyracksDataException {
        try {
            this.fieldData.getDataOutput().write(bytes, start, length);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        this.fEndOffsets[this.nextField++] = this.fieldData.getLength();
    }

    public DataOutput getDataOutput() {
        return this.fieldData.getDataOutput();
    }

    public GrowableArray getFieldData() {
        return this.fieldData;
    }

    public void addFieldEndOffset() {
        this.fEndOffsets[this.nextField++] = this.fieldData.getLength();
    }
}

