/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.common.constraints;

import edu.uci.ics.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import edu.uci.ics.hyracks.algebricks.common.constraints.AlgebricksCountPartitionConstraint;
import edu.uci.ics.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import edu.uci.ics.hyracks.api.constraints.PartitionConstraintHelper;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.job.JobSpecification;

public class AlgebricksPartitionConstraintHelper {
    public static void setPartitionConstraintInJobSpec(JobSpecification jobSpec, IOperatorDescriptor opDesc, AlgebricksPartitionConstraint apc) {
        switch (apc.getPartitionConstraintType()) {
            case ABSOLUTE: {
                AlgebricksAbsolutePartitionConstraint absPc = (AlgebricksAbsolutePartitionConstraint)apc;
                PartitionConstraintHelper.addAbsoluteLocationConstraint((JobSpecification)jobSpec, (IOperatorDescriptor)opDesc, (String[])absPc.getLocations());
                break;
            }
            case COUNT: {
                AlgebricksCountPartitionConstraint cntPc = (AlgebricksCountPartitionConstraint)apc;
                PartitionConstraintHelper.addPartitionCountConstraint((JobSpecification)jobSpec, (IOperatorDescriptor)opDesc, (int)cntPc.getCount());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static int getPartitionCount(AlgebricksPartitionConstraint partitionConstraint) {
        switch (partitionConstraint.getPartitionConstraintType()) {
            case COUNT: {
                AlgebricksCountPartitionConstraint pcc = (AlgebricksCountPartitionConstraint)partitionConstraint;
                return pcc.getCount();
            }
            case ABSOLUTE: {
                AlgebricksAbsolutePartitionConstraint epc = (AlgebricksAbsolutePartitionConstraint)partitionConstraint;
                return epc.getLocations().length;
            }
        }
        throw new IllegalStateException();
    }
}

