/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.rtree.tuples;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.tuples.TypeAwareTupleWriter;
import java.nio.ByteBuffer;

public class RTreeTypeAwareTupleWriter
extends TypeAwareTupleWriter {
    public RTreeTypeAwareTupleWriter(ITypeTraits[] typeTraits) {
        super(typeTraits);
    }

    public int writeTupleFields(ITreeIndexTupleReference[] refs, int startField, ByteBuffer targetBuf, int targetOff) {
        int i;
        int runner = targetOff;
        int nullFlagsBytes = this.getNullFlagsBytes(refs.length);
        for (i = 0; i < nullFlagsBytes; ++i) {
            targetBuf.put(runner++, (byte)0);
        }
        this.encDec.reset(targetBuf.array(), runner);
        for (i = startField; i < startField + refs.length; ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            this.encDec.encode(refs[i].getFieldLength(i));
        }
        runner = this.encDec.getPos();
        for (i = 0; i < refs.length; ++i) {
            System.arraycopy(refs[i].getFieldData(i), refs[i].getFieldStart(i), targetBuf.array(), runner, refs[i].getFieldLength(i));
            runner += refs[i].getFieldLength(i);
        }
        return runner - targetOff;
    }
}

