/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.rtree.linearize;

import edu.uci.ics.hyracks.api.dataflow.value.ILinearizeComparator;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.DoubleArrayList;

public class ZCurveIntComparator
implements ILinearizeComparator {
    private final int dim;
    private double[] bounds;
    private double stepsize;
    private DoubleArrayList boundsStack = new DoubleArrayList(2000, 400);
    private int[] a;
    private int[] b;

    public ZCurveIntComparator(int dimension) {
        this.dim = dimension;
        this.a = new int[this.dim];
        this.b = new int[this.dim];
        this.resetStateMachine();
    }

    private void resetStateMachine() {
        this.stepsize = 1.073741823E9;
        this.bounds = new double[this.dim];
        this.boundsStack.clear();
    }

    public int compare() {
        int quadrantB;
        int quadrantA;
        block15: {
            int j;
            boolean zoomOut;
            boolean equal = true;
            for (int i = 0; i < this.dim; ++i) {
                if (this.a[i] == this.b[i]) continue;
                equal = false;
            }
            if (equal) {
                return 0;
            }
            do {
                if (this.boundsStack.size() <= this.dim) {
                    this.resetStateMachine();
                    break block15;
                }
                zoomOut = false;
                for (int i = 0; i < this.dim; ++i) {
                    if (!((double)Math.min(this.a[i], this.b[i]) <= this.bounds[i] - 2.0 * this.stepsize) && !((double)Math.max(this.a[i], this.b[i]) >= this.bounds[i] + 2.0 * this.stepsize)) continue;
                    zoomOut = true;
                    break;
                }
                for (j = this.dim - 1; j >= 0; --j) {
                    this.bounds[j] = this.boundsStack.getLast();
                    this.boundsStack.removeLast();
                }
                this.stepsize *= 2.0;
            } while (zoomOut);
            for (j = this.dim - 1; j >= 0; --j) {
                this.bounds[j] = this.boundsStack.getLast();
                this.boundsStack.removeLast();
            }
            this.stepsize *= 2.0;
        }
        do {
            for (int j = 0; j < this.dim; ++j) {
                this.boundsStack.add(this.bounds[j]);
            }
            quadrantA = 0;
            quadrantB = 0;
            for (int i = this.dim - 1; i >= 0; --i) {
                if ((double)this.a[i] >= this.bounds[i]) {
                    quadrantA ^= 1 << this.dim - i - 1;
                }
                if ((double)this.b[i] >= this.bounds[i]) {
                    quadrantB ^= 1 << this.dim - i - 1;
                }
                if ((double)this.a[i] >= this.bounds[i]) {
                    int n = i;
                    this.bounds[n] = this.bounds[n] + this.stepsize;
                    continue;
                }
                int n = i;
                this.bounds[n] = this.bounds[n] - this.stepsize;
            }
            this.stepsize /= 2.0;
            if (!(this.stepsize <= 2.0 * DoublePointable.getEpsilon())) continue;
            return 0;
        } while (quadrantA == quadrantB);
        if (quadrantA < quadrantB) {
            return -1;
        }
        if (quadrantA > quadrantB) {
            return 1;
        }
        return 0;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        for (int i = 0; i < this.dim; ++i) {
            this.a[i] = IntegerSerializerDeserializer.getInt((byte[])b1, (int)(s1 + i * 8));
            this.b[i] = IntegerSerializerDeserializer.getInt((byte[])b2, (int)(s2 + i * 8));
        }
        return this.compare();
    }

    public int getDimensions() {
        return this.dim;
    }
}

