/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.rtree.impls;

import edu.uci.ics.hyracks.storage.am.rtree.impls.EntriesOrder;
import edu.uci.ics.hyracks.storage.am.rtree.impls.TupleEntry;
import java.util.Arrays;
import java.util.Collections;

public class TupleEntryArrayList {
    private TupleEntry[] data;
    private int size;
    private final int growth;

    public TupleEntryArrayList(int initialCapacity, int growth) {
        this.data = new TupleEntry[initialCapacity];
        this.size = 0;
        this.growth = growth;
    }

    public int size() {
        return this.size;
    }

    public void add(int tupleIndex, double value) {
        if (this.size == this.data.length) {
            TupleEntry[] newData = new TupleEntry[this.data.length + this.growth];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        if (this.data[this.size] == null) {
            this.data[this.size] = new TupleEntry();
        }
        this.data[this.size].setTupleIndex(tupleIndex);
        this.data[this.size].setValue(value);
        ++this.size;
    }

    public void removeLast() {
        if (this.size > 0) {
            --this.size;
        }
    }

    public TupleEntry getLast() {
        return this.data[this.size - 1];
    }

    public TupleEntry get(int i) {
        return this.data[i];
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void sort(EntriesOrder order, int tupleCount) {
        if (order == EntriesOrder.ASCENDING) {
            Arrays.sort(this.data, 0, tupleCount);
        } else {
            Arrays.sort(this.data, 0, tupleCount, Collections.reverseOrder());
        }
    }
}

