/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.rtree.impls;

import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.ICursorInitialState;
import edu.uci.ics.hyracks.storage.am.common.api.IFreePageManager;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexBulkLoader;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexCursor;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexOperationContext;
import edu.uci.ics.hyracks.storage.am.common.api.IModificationOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchPredicate;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexAccessor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexCursor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.IndexException;
import edu.uci.ics.hyracks.storage.am.common.api.TreeIndexException;
import edu.uci.ics.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import edu.uci.ics.hyracks.storage.am.common.impls.AbstractTreeIndex;
import edu.uci.ics.hyracks.storage.am.common.impls.NodeFrontier;
import edu.uci.ics.hyracks.storage.am.common.impls.TreeIndexDiskOrderScanCursor;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.IndexOperation;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import edu.uci.ics.hyracks.storage.am.common.util.TreeIndexUtils;
import edu.uci.ics.hyracks.storage.am.rtree.api.IRTreeFrame;
import edu.uci.ics.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import edu.uci.ics.hyracks.storage.am.rtree.api.IRTreeLeafFrame;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreeNSMFrame;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreeNSMInteriorFrame;
import edu.uci.ics.hyracks.storage.am.rtree.impls.RTreeOpContext;
import edu.uci.ics.hyracks.storage.am.rtree.impls.RTreeSearchCursor;
import edu.uci.ics.hyracks.storage.am.rtree.impls.SearchPredicate;
import edu.uci.ics.hyracks.storage.am.rtree.tuples.RTreeTypeAwareTupleWriter;
import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCache;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import edu.uci.ics.hyracks.storage.common.file.BufferedFileHandle;
import edu.uci.ics.hyracks.storage.common.file.IFileMapProvider;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class RTree
extends AbstractTreeIndex {
    private final AtomicLong globalNsn = new AtomicLong();
    private final int maxTupleSize;

    public RTree(IBufferCache bufferCache, IFileMapProvider fileMapProvider, IFreePageManager freePageManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory, IBinaryComparatorFactory[] cmpFactories, int fieldCount, FileReference file) {
        super(bufferCache, fileMapProvider, freePageManager, interiorFrameFactory, leafFrameFactory, cmpFactories, fieldCount, file);
        ITreeIndexFrame leafFrame = leafFrameFactory.createFrame();
        ITreeIndexFrame interiorFrame = interiorFrameFactory.createFrame();
        this.maxTupleSize = Math.min(leafFrame.getMaxTupleSize(bufferCache.getPageSize()), interiorFrame.getMaxTupleSize(bufferCache.getPageSize()));
    }

    private long incrementGlobalNsn() {
        return this.globalNsn.incrementAndGet();
    }

    public String printTree(IRTreeLeafFrame leafFrame, IRTreeInteriorFrame interiorFrame, ISerializerDeserializer[] keySerdes) throws Exception {
        MultiComparator cmp = MultiComparator.create((IBinaryComparatorFactory[])this.cmpFactories);
        byte treeHeight = this.getTreeHeight(leafFrame);
        StringBuilder strBuilder = new StringBuilder();
        this.printTree(1, null, false, leafFrame, interiorFrame, treeHeight, keySerdes, strBuilder, cmp);
        return strBuilder.toString();
    }

    public void printTree(int pageId, ICachedPage parent, boolean unpin, IRTreeLeafFrame leafFrame, IRTreeInteriorFrame interiorFrame, byte treeHeight, ISerializerDeserializer[] keySerdes, StringBuilder strBuilder, MultiComparator cmp) throws Exception {
        ICachedPage node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
        node.acquireReadLatch();
        try {
            int rightPage;
            long NSN;
            long LSN;
            String keyString;
            if (parent != null && unpin) {
                parent.releaseReadLatch();
                this.bufferCache.unpin(parent);
            }
            interiorFrame.setPage(node);
            byte level = interiorFrame.getLevel();
            strBuilder.append(String.format("%1d ", level));
            strBuilder.append(String.format("%3d ", pageId) + ": ");
            for (int i = 0; i < treeHeight - level; ++i) {
                strBuilder.append("    ");
            }
            if (interiorFrame.isLeaf()) {
                leafFrame.setPage(node);
                keyString = TreeIndexUtils.printFrameTuples((ITreeIndexFrame)leafFrame, (ISerializerDeserializer[])keySerdes);
                LSN = leafFrame.getPageLsn();
                NSN = leafFrame.getPageNsn();
                rightPage = leafFrame.getRightPage();
            } else {
                keyString = TreeIndexUtils.printFrameTuples((ITreeIndexFrame)interiorFrame, (ISerializerDeserializer[])keySerdes);
                LSN = interiorFrame.getPageLsn();
                NSN = interiorFrame.getPageNsn();
                rightPage = interiorFrame.getRightPage();
            }
            strBuilder.append(keyString + "\n" + "pageId: " + pageId + " LSN: " + LSN + " NSN: " + NSN + " rightPage: " + rightPage + "\n");
            if (!interiorFrame.isLeaf()) {
                ArrayList<Integer> children = ((RTreeNSMInteriorFrame)interiorFrame).getChildren(cmp);
                for (int i = 0; i < children.size(); ++i) {
                    this.printTree(children.get(i), node, i == children.size() - 1, leafFrame, interiorFrame, treeHeight, keySerdes, strBuilder, cmp);
                }
            } else {
                node.releaseReadLatch();
                this.bufferCache.unpin(node);
            }
        }
        catch (Exception e) {
            node.releaseReadLatch();
            this.bufferCache.unpin(node);
            e.printStackTrace();
        }
    }

    private RTreeOpContext createOpContext(IModificationOperationCallback modificationCallback) {
        return new RTreeOpContext((IRTreeLeafFrame)this.leafFrameFactory.createFrame(), (IRTreeInteriorFrame)this.interiorFrameFactory.createFrame(), this.freePageManager.getMetaDataFrameFactory().createFrame(), this.cmpFactories, modificationCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(ITupleReference tuple, IIndexOperationContext ictx) throws HyracksDataException, TreeIndexException {
        int i;
        RTreeOpContext ctx = (RTreeOpContext)ictx;
        int tupleSize = Math.max(ctx.leafFrame.getBytesRequriedToWriteTuple(tuple), ctx.interiorFrame.getBytesRequriedToWriteTuple(tuple));
        if (tupleSize > this.maxTupleSize) {
            throw new TreeIndexException("Record size (" + tupleSize + ") larger than maximum acceptable record size (" + this.maxTupleSize + ")");
        }
        ctx.reset();
        ctx.setTuple(tuple);
        ctx.splitKey.reset();
        ctx.splitKey.getLeftTuple().setFieldCount(this.cmpFactories.length);
        ctx.splitKey.getRightTuple().setFieldCount(this.cmpFactories.length);
        ctx.modificationCallback.before(tuple);
        int maxFieldPos = this.cmpFactories.length / 2;
        for (int i2 = 0; i2 < maxFieldPos; ++i2) {
            int j = maxFieldPos + i2;
            int c = ctx.cmp.getComparators()[i2].compare(tuple.getFieldData(i2), tuple.getFieldStart(i2), tuple.getFieldLength(i2), tuple.getFieldData(j), tuple.getFieldStart(j), tuple.getFieldLength(j));
            if (c <= 0) continue;
            throw new IllegalArgumentException("The low key point has larger coordinates than the high key point.");
        }
        try {
            ICachedPage leafNode = this.findLeaf(ctx);
            int pageId = ctx.pathList.getLastPageId();
            ctx.pathList.moveLast();
            this.insertTuple(leafNode, pageId, ctx.getTuple(), ctx, true);
            while (ctx.splitKey.getLeftPageBuffer() != null) {
                this.updateParentForInsert(ctx);
            }
        }
        catch (Throwable throwable) {
            ICachedPage node;
            int i3;
            for (i3 = ctx.NSNUpdates.size() - 1; i3 >= 0; --i3) {
                node = ctx.NSNUpdates.get(i3);
                ctx.interiorFrame.setPage(node);
                ctx.interiorFrame.setPageNsn(this.incrementGlobalNsn());
            }
            for (i3 = ctx.LSNUpdates.size() - 1; i3 >= 0; --i3) {
                node = ctx.LSNUpdates.get(i3);
                ctx.interiorFrame.setPage(node);
                ctx.interiorFrame.setPageLsn(this.incrementGlobalNsn());
                node.releaseWriteLatch(true);
                this.bufferCache.unpin(node);
            }
            throw throwable;
        }
        for (i = ctx.NSNUpdates.size() - 1; i >= 0; --i) {
            ICachedPage node = ctx.NSNUpdates.get(i);
            ctx.interiorFrame.setPage(node);
            ctx.interiorFrame.setPageNsn(this.incrementGlobalNsn());
        }
        for (i = ctx.LSNUpdates.size() - 1; i >= 0; --i) {
            ICachedPage node = ctx.LSNUpdates.get(i);
            ctx.interiorFrame.setPage(node);
            ctx.interiorFrame.setPageLsn(this.incrementGlobalNsn());
            node.releaseWriteLatch(true);
            this.bufferCache.unpin(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedPage findLeaf(RTreeOpContext ctx) throws HyracksDataException {
        int pageId = 1;
        boolean writeLatched = false;
        boolean readLatched = false;
        boolean succeeded = false;
        ICachedPage node = null;
        boolean isLeaf = false;
        long pageLsn = 0L;
        long parentLsn = 0L;
        try {
            while (true) {
                if (!writeLatched) {
                    node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
                    ctx.interiorFrame.setPage(node);
                    isLeaf = ctx.interiorFrame.isLeaf();
                    if (isLeaf) {
                        node.acquireWriteLatch();
                        writeLatched = true;
                        if (!ctx.interiorFrame.isLeaf()) {
                            node.releaseWriteLatch(true);
                            writeLatched = false;
                            this.bufferCache.unpin(node);
                            continue;
                        }
                    } else {
                        node.acquireReadLatch();
                        readLatched = true;
                    }
                }
                if (pageId != 1 && parentLsn < ctx.interiorFrame.getPageNsn()) {
                    if (writeLatched) {
                        node.releaseWriteLatch(true);
                        writeLatched = false;
                        this.bufferCache.unpin(node);
                    } else {
                        node.releaseReadLatch();
                        readLatched = false;
                        this.bufferCache.unpin(node);
                    }
                    pageId = ctx.pathList.getLastPageId();
                    if (pageId != 1) {
                        parentLsn = ctx.pathList.getPageLsn(ctx.pathList.size() - 2);
                    }
                    ctx.pathList.moveLast();
                    continue;
                }
                pageLsn = ctx.interiorFrame.getPageLsn();
                ctx.pathList.add(pageId, pageLsn, -1);
                if (isLeaf) break;
                int childPageId = ctx.interiorFrame.findBestChild(ctx.getTuple(), ctx.cmp);
                boolean enlarementIsNeeded = ctx.interiorFrame.checkIfEnlarementIsNeeded(ctx.getTuple(), ctx.cmp);
                if (enlarementIsNeeded) {
                    if (!writeLatched) {
                        node.releaseReadLatch();
                        readLatched = false;
                        this.bufferCache.unpin(node);
                        node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
                        node.acquireWriteLatch();
                        writeLatched = true;
                        ctx.interiorFrame.setPage(node);
                        if (ctx.interiorFrame.getPageLsn() != pageLsn) {
                            ctx.pathList.moveLast();
                            continue;
                        }
                    }
                    ctx.interiorFrame.enlarge(ctx.getTuple(), ctx.cmp);
                    node.releaseWriteLatch(true);
                    writeLatched = false;
                    this.bufferCache.unpin(node);
                } else if (readLatched) {
                    node.releaseReadLatch();
                    readLatched = false;
                    this.bufferCache.unpin(node);
                } else if (writeLatched) {
                    node.releaseWriteLatch(true);
                    writeLatched = false;
                    this.bufferCache.unpin(node);
                }
                pageId = childPageId;
                parentLsn = pageLsn;
            }
            ctx.leafFrame.setPage(node);
            succeeded = true;
            ICachedPage iCachedPage = node;
            return iCachedPage;
        }
        finally {
            if (!succeeded) {
                if (readLatched) {
                    node.releaseReadLatch();
                    readLatched = false;
                    this.bufferCache.unpin(node);
                } else if (writeLatched) {
                    node.releaseWriteLatch(true);
                    writeLatched = false;
                    this.bufferCache.unpin(node);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void insertTuple(ICachedPage node, int pageId, ITupleReference tuple, RTreeOpContext ctx, boolean isLeaf) throws HyracksDataException, TreeIndexException {
        succeeded = false;
        spaceStatus = isLeaf == false ? ctx.interiorFrame.hasSpaceInsert(tuple) : ctx.leafFrame.hasSpaceInsert(tuple);
        switch (1.$SwitchMap$edu$uci$ics$hyracks$storage$am$common$frames$FrameOpSpaceStatus[spaceStatus.ordinal()]) {
            case 1: {
                try {
                    if (!isLeaf) {
                        ctx.interiorFrame.insert(tuple, -1);
                    } else {
                        ctx.modificationCallback.found(null, tuple);
                        ctx.leafFrame.insert(tuple, -1);
                    }
                    succeeded = true;
                    if (!succeeded) ** GOTO lbl27
                    ctx.LSNUpdates.add(node);
                }
                catch (Throwable var8_8) {
                    if (succeeded) {
                        ctx.LSNUpdates.add(node);
                        ctx.splitKey.reset();
                    } else if (isLeaf) {
                        node.releaseWriteLatch(true);
                        this.bufferCache.unpin(node);
                    }
                    throw var8_8;
                }
                ctx.splitKey.reset();
                break;
lbl27:
                // 1 sources

                if (!isLeaf) break;
                node.releaseWriteLatch(true);
                this.bufferCache.unpin(node);
                break;
            }
            case 2: {
                try {
                    if (!isLeaf) {
                        ctx.interiorFrame.compact();
                        ctx.interiorFrame.insert(tuple, -1);
                    } else {
                        ctx.leafFrame.compact();
                        ctx.modificationCallback.found(null, tuple);
                        ctx.leafFrame.insert(tuple, -1);
                    }
                    succeeded = true;
                    if (!succeeded) ** GOTO lbl58
                    ctx.LSNUpdates.add(node);
                }
                catch (Throwable var9_10) {
                    if (succeeded) {
                        ctx.LSNUpdates.add(node);
                        ctx.splitKey.reset();
                    } else if (isLeaf) {
                        node.releaseWriteLatch(true);
                        this.bufferCache.unpin(node);
                    }
                    throw var9_10;
                }
                ctx.splitKey.reset();
                break;
lbl58:
                // 1 sources

                if (!isLeaf) break;
                node.releaseWriteLatch(true);
                this.bufferCache.unpin(node);
                break;
            }
            case 3: {
                rightPageId = this.freePageManager.getFreePage(ctx.metaFrame);
                rightNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)rightPageId), true);
                rightNode.acquireWriteLatch();
                try {
                    if (!isLeaf) {
                        rightFrame = (IRTreeFrame)this.interiorFrameFactory.createFrame();
                        rightFrame.setPage(rightNode);
                        rightFrame.initBuffer(ctx.interiorFrame.getLevel());
                        rightFrame.setRightPage(ctx.interiorFrame.getRightPage());
                        ctx.interiorFrame.split(rightFrame, tuple, ctx.splitKey);
                        ctx.interiorFrame.setRightPage(rightPageId);
                    } else {
                        rightFrame = (IRTreeFrame)this.leafFrameFactory.createFrame();
                        rightFrame.setPage(rightNode);
                        rightFrame.initBuffer((byte)0);
                        rightFrame.setRightPage(ctx.interiorFrame.getRightPage());
                        ctx.modificationCallback.found(null, tuple);
                        ctx.leafFrame.split(rightFrame, tuple, ctx.splitKey);
                        ctx.leafFrame.setRightPage(rightPageId);
                    }
                    succeeded = true;
                }
                finally {
                    if (succeeded) {
                        ctx.NSNUpdates.add(rightNode);
                        ctx.LSNUpdates.add(rightNode);
                        ctx.NSNUpdates.add(node);
                        ctx.LSNUpdates.add(node);
                    } else if (isLeaf) {
                        node.releaseWriteLatch(true);
                        this.bufferCache.unpin(node);
                        rightNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(rightNode);
                    } else {
                        rightNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(rightNode);
                    }
                }
                ctx.splitKey.setPages(pageId, rightPageId);
                if (pageId != 1) break;
                newLeftId = this.freePageManager.getFreePage(ctx.metaFrame);
                newLeftNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)newLeftId), true);
                newLeftNode.acquireWriteLatch();
                succeeded = false;
                try {
                    System.arraycopy(node.getBuffer().array(), 0, newLeftNode.getBuffer().array(), 0, newLeftNode.getBuffer().capacity());
                    ctx.interiorFrame.setPage(node);
                    ctx.interiorFrame.initBuffer((byte)(ctx.interiorFrame.getLevel() + 1));
                    ctx.splitKey.setLeftPage(newLeftId);
                    ctx.interiorFrame.insert((ITupleReference)ctx.splitKey.getLeftTuple(), -1);
                    ctx.interiorFrame.insert((ITupleReference)ctx.splitKey.getRightTuple(), -1);
                    succeeded = true;
                    if (!succeeded) ** GOTO lbl162
                    ctx.NSNUpdates.remove(ctx.NSNUpdates.size() - 1);
                }
                catch (Throwable var12_16) {
                    if (succeeded) {
                        ctx.NSNUpdates.remove(ctx.NSNUpdates.size() - 1);
                        ctx.LSNUpdates.remove(ctx.LSNUpdates.size() - 1);
                        ctx.NSNUpdates.add(newLeftNode);
                        ctx.LSNUpdates.add(newLeftNode);
                        ctx.NSNUpdates.add(node);
                        ctx.LSNUpdates.add(node);
                        ctx.splitKey.reset();
                    } else if (isLeaf) {
                        node.releaseWriteLatch(true);
                        this.bufferCache.unpin(node);
                        rightNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(rightNode);
                        newLeftNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(newLeftNode);
                    } else {
                        rightNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(rightNode);
                        newLeftNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(newLeftNode);
                    }
                    throw var12_16;
                }
                ctx.LSNUpdates.remove(ctx.LSNUpdates.size() - 1);
                ctx.NSNUpdates.add(newLeftNode);
                ctx.LSNUpdates.add(newLeftNode);
                ctx.NSNUpdates.add(node);
                ctx.LSNUpdates.add(node);
                ctx.splitKey.reset();
                break;
lbl162:
                // 1 sources

                if (isLeaf) {
                    node.releaseWriteLatch(true);
                    this.bufferCache.unpin(node);
                    rightNode.releaseWriteLatch(true);
                    this.bufferCache.unpin(rightNode);
                    newLeftNode.releaseWriteLatch(true);
                    this.bufferCache.unpin(newLeftNode);
                    break;
                }
                rightNode.releaseWriteLatch(true);
                this.bufferCache.unpin(rightNode);
                newLeftNode.releaseWriteLatch(true);
                this.bufferCache.unpin(newLeftNode);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateParentForInsert(RTreeOpContext ctx) throws HyracksDataException, TreeIndexException {
        block10: {
            boolean succeeded = false;
            boolean writeLatched = false;
            int parentId = ctx.pathList.getLastPageId();
            ICachedPage parentNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)parentId), false);
            parentNode.acquireWriteLatch();
            writeLatched = true;
            ctx.interiorFrame.setPage(parentNode);
            boolean foundParent = true;
            try {
                if (ctx.interiorFrame.getPageLsn() != ctx.pathList.getLastPageLsn()) {
                    foundParent = false;
                    while (true) {
                        if (ctx.interiorFrame.findTupleByPointer((ITupleReference)ctx.splitKey.getLeftTuple(), ctx.cmp) != -1) {
                            foundParent = true;
                            break;
                        }
                        int rightPage = ctx.interiorFrame.getRightPage();
                        parentNode.releaseWriteLatch(true);
                        writeLatched = false;
                        this.bufferCache.unpin(parentNode);
                        if (rightPage == -1) break;
                        parentId = rightPage;
                        parentNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)parentId), false);
                        parentNode.acquireWriteLatch();
                        writeLatched = true;
                        ctx.interiorFrame.setPage(parentNode);
                    }
                }
                if (!foundParent) break block10;
                try {
                    ctx.interiorFrame.adjustKey((ITupleReference)ctx.splitKey.getLeftTuple(), -1, ctx.cmp);
                }
                catch (TreeIndexException e) {
                    if (writeLatched) {
                        parentNode.releaseWriteLatch(true);
                        writeLatched = false;
                        this.bufferCache.unpin(parentNode);
                    }
                    throw e;
                }
                this.insertTuple(parentNode, parentId, (ITupleReference)ctx.splitKey.getRightTuple(), ctx, ctx.interiorFrame.isLeaf());
                ctx.pathList.moveLast();
                succeeded = true;
                return;
            }
            finally {
                if (!succeeded && writeLatched) {
                    parentNode.releaseWriteLatch(true);
                    writeLatched = false;
                    this.bufferCache.unpin(parentNode);
                }
            }
        }
        ctx.traverseList.clear();
        this.findPath(ctx);
        this.updateParentForInsert(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void findPath(RTreeOpContext ctx) throws TreeIndexException, HyracksDataException {
        block11: {
            boolean readLatched = false;
            int pageId = 1;
            int parentIndex = -1;
            long parentLsn = 0L;
            ICachedPage node = null;
            ctx.traverseList.add(pageId, -1L, parentIndex);
            while (true) {
                block9: {
                    block10: {
                        int rightPage;
                        if (ctx.traverseList.isLast()) break;
                        pageId = ctx.traverseList.getFirstPageId();
                        parentIndex = ctx.traverseList.getFirstPageIndex();
                        node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
                        node.acquireReadLatch();
                        readLatched = true;
                        ctx.interiorFrame.setPage(node);
                        long pageLsn = ctx.interiorFrame.getPageLsn();
                        int pageIndex = ctx.traverseList.first();
                        ctx.traverseList.setPageLsn(pageIndex, pageLsn);
                        ctx.traverseList.moveFirst();
                        if (ctx.interiorFrame.isLeaf()) {
                            throw new TreeIndexException("Error: Failed to re-find parent of a page in the tree.");
                        }
                        if (pageId != 1) {
                            parentLsn = ctx.traverseList.getPageLsn(ctx.traverseList.getPageIndex(pageIndex));
                        }
                        if (pageId != 1 && parentLsn < ctx.interiorFrame.getPageNsn() && (rightPage = ctx.interiorFrame.getRightPage()) != -1) {
                            ctx.traverseList.addFirst(rightPage, -1L, parentIndex);
                        }
                        if (ctx.interiorFrame.findTupleByPointer((ITupleReference)ctx.splitKey.getLeftTuple(), ctx.traverseList, pageIndex, ctx.cmp) == -1) break block9;
                        ctx.pathList.clear();
                        this.fillPath(ctx, pageIndex);
                        if (!readLatched) break block10;
                        node.releaseReadLatch();
                        readLatched = false;
                        this.bufferCache.unpin(node);
                    }
                    return;
                }
                node.releaseReadLatch();
                readLatched = false;
                this.bufferCache.unpin(node);
                continue;
                break;
            }
            if (readLatched) {
                node.releaseReadLatch();
                readLatched = false;
                this.bufferCache.unpin(node);
            }
            break block11;
            catch (Throwable throwable) {
                if (readLatched) {
                    node.releaseReadLatch();
                    readLatched = false;
                    this.bufferCache.unpin(node);
                }
                throw throwable;
            }
        }
    }

    private void fillPath(RTreeOpContext ctx, int pageIndex) {
        if (pageIndex != -1) {
            this.fillPath(ctx, ctx.traverseList.getPageIndex(pageIndex));
            ctx.pathList.add(ctx.traverseList.getPageId(pageIndex), ctx.traverseList.getPageLsn(pageIndex), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(ITupleReference tuple, RTreeOpContext ctx) throws HyracksDataException, TreeIndexException {
        ctx.reset();
        ctx.setTuple(tuple);
        ctx.splitKey.reset();
        ctx.splitKey.getLeftTuple().setFieldCount(this.cmpFactories.length);
        int tupleIndex = this.findTupleToDelete(ctx);
        if (tupleIndex != -1) {
            try {
                this.deleteTuple(tupleIndex, ctx);
            }
            finally {
                ctx.leafFrame.getPage().releaseWriteLatch(true);
                this.bufferCache.unpin(ctx.leafFrame.getPage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findTupleToDelete(RTreeOpContext ctx) throws HyracksDataException {
        writeLatched = false;
        readLatched = false;
        succeeded = false;
        node = null;
        ctx.pathList.add(1, -1L, -1);
        while (true) {
            block15: {
                block13: {
                    block14: {
                        try {
                            while (!ctx.pathList.isEmpty()) {
                                block16: {
                                    pageId = ctx.pathList.getLastPageId();
                                    parentLsn = ctx.pathList.getLastPageLsn();
                                    ctx.pathList.moveLast();
                                    node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
                                    node.acquireReadLatch();
                                    readLatched = true;
                                    ctx.interiorFrame.setPage(node);
                                    isLeaf = ctx.interiorFrame.isLeaf();
                                    pageLsn = ctx.interiorFrame.getPageLsn();
                                    if (pageId != 1 && parentLsn < ctx.interiorFrame.getPageNsn() && (rightPage = ctx.interiorFrame.getRightPage()) != -1) {
                                        ctx.pathList.add(rightPage, parentLsn, -1);
                                    }
                                    if (isLeaf) break block16;
                                    for (i = 0; i < ctx.interiorFrame.getTupleCount(); ++i) {
                                        childPageId = ctx.interiorFrame.getChildPageIdIfIntersect(ctx.tuple, i, ctx.cmp);
                                        if (childPageId == -1) continue;
                                        ctx.pathList.add(childPageId, pageLsn, -1);
                                    }
                                    ** GOTO lbl-1000
                                }
                                ctx.leafFrame.setPage(node);
                                tupleIndex = ctx.leafFrame.findTupleIndex(ctx.tuple, ctx.cmp);
                                if (tupleIndex == -1) ** GOTO lbl-1000
                                node.releaseReadLatch();
                                readLatched = false;
                                this.bufferCache.unpin(node);
                                node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
                                node.acquireWriteLatch();
                                writeLatched = true;
                                ctx.leafFrame.setPage(node);
                                if (!ctx.leafFrame.isLeaf()) {
                                    ctx.pathList.add(pageId, -1L, -1);
                                    node.releaseWriteLatch(true);
                                    writeLatched = false;
                                    this.bufferCache.unpin(node);
                                    continue;
                                }
                                if (ctx.leafFrame.getPageLsn() != pageLsn) {
                                    tupleIndex = ctx.leafFrame.findTupleIndex(ctx.tuple, ctx.cmp);
                                    if (tupleIndex == -1) {
                                        ctx.pathList.add(pageId, parentLsn, -1);
                                        node.releaseWriteLatch(true);
                                        writeLatched = false;
                                        this.bufferCache.unpin(node);
                                        continue;
                                    }
                                    succeeded = true;
                                    var13_11 = tupleIndex;
                                    if (succeeded != false) return var13_11;
                                    if (!readLatched) break block13;
                                    break block14;
                                }
                                ** GOTO lbl-1000
                            }
                            break;
                        }
                        catch (Throwable var14_12) {
                            if (succeeded != false) throw var14_12;
                            if (readLatched) {
                                node.releaseReadLatch();
                                readLatched = false;
                                this.bufferCache.unpin(node);
                                throw var14_12;
                            }
                            if (writeLatched == false) throw var14_12;
                            node.releaseWriteLatch(true);
                            writeLatched = false;
                            this.bufferCache.unpin(node);
                            throw var14_12;
                        }
                    }
                    node.releaseReadLatch();
                    readLatched = false;
                    this.bufferCache.unpin(node);
                    return var13_11;
                }
                if (writeLatched == false) return var13_11;
                node.releaseWriteLatch(true);
                writeLatched = false;
                this.bufferCache.unpin(node);
                return var13_11;
lbl-1000:
                // 1 sources

                {
                    succeeded = true;
                    var13_11 = tupleIndex;
                    if (succeeded != false) return var13_11;
                    if (!readLatched) break block15;
                }
                node.releaseReadLatch();
                readLatched = false;
                this.bufferCache.unpin(node);
                return var13_11;
            }
            if (writeLatched == false) return var13_11;
            node.releaseWriteLatch(true);
            writeLatched = false;
            this.bufferCache.unpin(node);
            return var13_11;
lbl-1000:
            // 2 sources

            {
                node.releaseReadLatch();
                readLatched = false;
                this.bufferCache.unpin(node);
                continue;
            }
            break;
        }
        if (succeeded != false) return -1;
        if (readLatched) {
            node.releaseReadLatch();
            readLatched = false;
            this.bufferCache.unpin(node);
            return -1;
        }
        if (writeLatched == false) return -1;
        node.releaseWriteLatch(true);
        writeLatched = false;
        this.bufferCache.unpin(node);
        return -1;
    }

    private void deleteTuple(int tupleIndex, RTreeOpContext ctx) throws HyracksDataException {
        ITupleReference beforeTuple = ctx.leafFrame.getBeforeTuple(ctx.getTuple(), tupleIndex, ctx.cmp);
        ctx.modificationCallback.found(beforeTuple, ctx.getTuple());
        ctx.leafFrame.delete(tupleIndex, ctx.cmp);
        ctx.leafFrame.setPageLsn(this.incrementGlobalNsn());
    }

    private void search(ITreeIndexCursor cursor, ISearchPredicate searchPred, RTreeOpContext ctx) throws HyracksDataException, IndexException {
        ctx.reset();
        ctx.cursor = cursor;
        cursor.setBufferCache(this.bufferCache);
        cursor.setFileId(this.fileId);
        ctx.cursorInitialState.setRootPage(1);
        ctx.cursor.open((ICursorInitialState)ctx.cursorInitialState, (ISearchPredicate)((SearchPredicate)searchPred));
    }

    private void update(ITupleReference tuple, RTreeOpContext ctx) {
        throw new UnsupportedOperationException("RTree Update not implemented.");
    }

    private void diskOrderScan(ITreeIndexCursor icursor, RTreeOpContext ctx) throws HyracksDataException {
        TreeIndexDiskOrderScanCursor cursor = (TreeIndexDiskOrderScanCursor)icursor;
        ctx.reset();
        MultiComparator cmp = MultiComparator.create((IBinaryComparatorFactory[])this.cmpFactories);
        SearchPredicate searchPred = new SearchPredicate(null, cmp);
        int currentPageId = 1;
        int maxPageId = this.freePageManager.getMaxPage(ctx.metaFrame);
        ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)currentPageId), false);
        page.acquireReadLatch();
        try {
            cursor.setBufferCache(this.bufferCache);
            cursor.setFileId(this.fileId);
            cursor.setCurrentPageId(currentPageId);
            cursor.setMaxPageId(maxPageId);
            ctx.cursorInitialState.setOriginialKeyComparator(ctx.cmp);
            ctx.cursorInitialState.setPage(page);
            cursor.open((ICursorInitialState)ctx.cursorInitialState, (ISearchPredicate)searchPred);
        }
        catch (Exception e) {
            page.releaseReadLatch();
            this.bufferCache.unpin(page);
            throw new HyracksDataException((Throwable)e);
        }
    }

    public ITreeIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new RTreeAccessor(this, modificationCallback, searchCallback);
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new RTreeBulkLoader(fillFactor);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public void validate() throws HyracksDataException {
        throw new UnsupportedOperationException("Validation not implemented for R-Trees.");
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$edu$uci$ics$hyracks$storage$am$common$frames$FrameOpSpaceStatus;

        static {
            $SwitchMap$edu$uci$ics$hyracks$storage$am$common$frames$FrameOpSpaceStatus = new int[FrameOpSpaceStatus.values().length];
            try {
                1.$SwitchMap$edu$uci$ics$hyracks$storage$am$common$frames$FrameOpSpaceStatus[FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$uci$ics$hyracks$storage$am$common$frames$FrameOpSpaceStatus[FrameOpSpaceStatus.SUFFICIENT_SPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$uci$ics$hyracks$storage$am$common$frames$FrameOpSpaceStatus[FrameOpSpaceStatus.INSUFFICIENT_SPACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public class RTreeBulkLoader
    extends AbstractTreeIndex.AbstractTreeIndexBulkLoader {
        ITreeIndexFrame lowerFrame;
        ITreeIndexFrame prevInteriorFrame;
        RTreeTypeAwareTupleWriter tupleWriter;
        ITreeIndexTupleReference mbrTuple;
        ByteBuffer mbr;

        public RTreeBulkLoader(float fillFactor) throws TreeIndexException, HyracksDataException {
            super((AbstractTreeIndex)RTree.this, fillFactor);
            this.tupleWriter = (RTreeTypeAwareTupleWriter)this.interiorFrame.getTupleWriter();
            this.mbrTuple = this.interiorFrame.createTupleReference();
            this.prevInteriorFrame = RTree.this.interiorFrameFactory.createFrame();
        }

        public void add(ITupleReference tuple) throws IndexException, HyracksDataException {
            try {
                int tupleSize = Math.max(this.leafFrame.getBytesRequriedToWriteTuple(tuple), this.interiorFrame.getBytesRequriedToWriteTuple(tuple));
                if (tupleSize > RTree.this.maxTupleSize) {
                    throw new TreeIndexException("Space required for record (" + tupleSize + ") larger than maximum acceptable size (" + RTree.this.maxTupleSize + ")");
                }
                NodeFrontier leafFrontier = (NodeFrontier)this.nodeFrontiers.get(0);
                int spaceNeeded = this.tupleWriter.bytesRequired(tuple) + this.slotSize;
                int spaceUsed = this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace();
                if (spaceUsed + spaceNeeded > this.leafMaxBytes) {
                    this.leafFrame.compress();
                    spaceUsed = this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace();
                }
                if (spaceUsed + spaceNeeded > this.leafMaxBytes) {
                    this.propagateBulk(1, false);
                    leafFrontier.pageId = RTree.this.freePageManager.getFreePage(this.metaFrame);
                    leafFrontier.page.releaseWriteLatch(true);
                    RTree.this.bufferCache.unpin(leafFrontier.page);
                    leafFrontier.page = RTree.this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)RTree.this.fileId, (int)leafFrontier.pageId), true);
                    leafFrontier.page.acquireWriteLatch();
                    this.leafFrame.setPage(leafFrontier.page);
                    this.leafFrame.initBuffer((byte)0);
                }
                this.leafFrame.setPage(leafFrontier.page);
                this.leafFrame.insert(tuple, -1);
            }
            catch (HyracksDataException e) {
                this.handleException();
                throw e;
            }
            catch (RuntimeException e) {
                this.handleException();
                throw e;
            }
        }

        public void end() throws HyracksDataException {
            this.propagateBulk(1, true);
            super.end();
        }

        protected void propagateBulk(int level, boolean toRoot) throws HyracksDataException {
            boolean propagated = false;
            if (level == 1) {
                this.lowerFrame = this.leafFrame;
            }
            if (this.lowerFrame.getTupleCount() == 0) {
                return;
            }
            if (level >= this.nodeFrontiers.size()) {
                this.addLevel();
            }
            ((RTreeNSMFrame)this.lowerFrame).adjustMBR();
            if (this.mbr == null) {
                int bytesRequired = this.tupleWriter.bytesRequired((ITupleReference)((RTreeNSMFrame)this.lowerFrame).getTuples()[0], 0, this.cmp.getKeyFieldCount()) + ((RTreeNSMInteriorFrame)this.interiorFrame).getChildPointerSize();
                this.mbr = ByteBuffer.allocate(bytesRequired);
            }
            this.tupleWriter.writeTupleFields(((RTreeNSMFrame)this.lowerFrame).getTuples(), 0, this.mbr, 0);
            this.mbrTuple.resetByTupleOffset(this.mbr, 0);
            NodeFrontier frontier = (NodeFrontier)this.nodeFrontiers.get(level);
            this.interiorFrame.setPage(frontier.page);
            this.interiorFrame.insert((ITupleReference)this.mbrTuple, -1);
            this.interiorFrame.getBuffer().putInt(this.interiorFrame.getTupleOffset(this.interiorFrame.getTupleCount() - 1) + this.mbrTuple.getTupleSize(), ((NodeFrontier)this.nodeFrontiers.get((int)(level - 1))).pageId);
            if (this.interiorFrame.hasSpaceInsert((ITupleReference)this.mbrTuple) != FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE && !toRoot) {
                this.lowerFrame = this.prevInteriorFrame;
                this.lowerFrame.setPage(frontier.page);
                this.propagateBulk(level + 1, toRoot);
                propagated = true;
                frontier.page.releaseWriteLatch(true);
                RTree.this.bufferCache.unpin(frontier.page);
                frontier.pageId = RTree.this.freePageManager.getFreePage(this.metaFrame);
                frontier.page = RTree.this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)RTree.this.fileId, (int)frontier.pageId), true);
                frontier.page.acquireWriteLatch();
                this.interiorFrame.setPage(frontier.page);
                this.interiorFrame.initBuffer((byte)level);
            }
            if (toRoot && !propagated && level < this.nodeFrontiers.size() - 1) {
                this.lowerFrame = this.prevInteriorFrame;
                this.lowerFrame.setPage(frontier.page);
                this.propagateBulk(level + 1, true);
            }
            this.leafFrame.setPage(((NodeFrontier)this.nodeFrontiers.get((int)0)).page);
        }
    }

    public class RTreeAccessor
    implements ITreeIndexAccessor {
        private RTree rtree;
        private RTreeOpContext ctx;

        public RTreeAccessor(RTree rtree, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
            this.rtree = rtree;
            this.ctx = rtree.createOpContext(modificationCallback);
        }

        public void insert(ITupleReference tuple) throws HyracksDataException, TreeIndexException {
            this.ctx.setOperation(IndexOperation.INSERT);
            this.rtree.insert(tuple, this.ctx);
        }

        public void update(ITupleReference tuple) throws HyracksDataException, TreeIndexException {
            this.ctx.setOperation(IndexOperation.UPDATE);
            this.rtree.update(tuple, this.ctx);
        }

        public void delete(ITupleReference tuple) throws HyracksDataException, TreeIndexException {
            this.ctx.setOperation(IndexOperation.DELETE);
            this.rtree.delete(tuple, this.ctx);
        }

        public ITreeIndexCursor createSearchCursor(boolean exclusive) {
            return new RTreeSearchCursor((IRTreeInteriorFrame)RTree.this.interiorFrameFactory.createFrame(), (IRTreeLeafFrame)RTree.this.leafFrameFactory.createFrame());
        }

        public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException, IndexException {
            this.ctx.setOperation(IndexOperation.SEARCH);
            this.rtree.search((ITreeIndexCursor)cursor, searchPred, this.ctx);
        }

        public ITreeIndexCursor createDiskOrderScanCursor() {
            return new TreeIndexDiskOrderScanCursor(RTree.this.leafFrameFactory.createFrame());
        }

        public void diskOrderScan(ITreeIndexCursor cursor) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.DISKORDERSCAN);
            this.rtree.diskOrderScan(cursor, this.ctx);
        }

        public RTreeOpContext getOpContext() {
            return this.ctx;
        }

        public void upsert(ITupleReference tuple) throws HyracksDataException, TreeIndexException {
            throw new UnsupportedOperationException("The RTree does not support the notion of keys, therefore upsert does not make sense.");
        }
    }
}

