/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.rtree.impls;

import edu.uci.ics.hyracks.storage.am.common.ophelpers.IntArrayList;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.LongArrayList;

public class PathList {
    private IntArrayList pageIds;
    private LongArrayList pageLsns;
    private IntArrayList pageIndexes;

    public PathList(int initialCapacity, int growth) {
        this.pageIds = new IntArrayList(initialCapacity, growth);
        this.pageLsns = new LongArrayList(initialCapacity, growth);
        this.pageIndexes = new IntArrayList(initialCapacity, growth);
    }

    public int size() {
        return this.pageIds.size();
    }

    public int first() {
        return this.pageIds.first();
    }

    public void add(int pageId, long pageLsn, int pageIndex) {
        this.pageIds.add(pageId);
        this.pageLsns.add(pageLsn);
        this.pageIndexes.add(pageIndex);
    }

    public void addFirst(int pageId, long pageLsn, int pageIndex) {
        this.pageIds.addFirst(pageId);
        this.pageLsns.addFirst(pageLsn);
        this.pageIndexes.addFirst(pageIndex);
    }

    public int getFirstPageId() {
        return this.pageIds.getFirst();
    }

    public long getFirstPageLsn() {
        return this.pageLsns.getFirst();
    }

    public int getFirstPageIndex() {
        return this.pageIndexes.getFirst();
    }

    public int getLastPageId() {
        return this.pageIds.getLast();
    }

    public long getLastPageLsn() {
        return this.pageLsns.getLast();
    }

    public int getLastPageIndex() {
        return this.pageIndexes.getLast();
    }

    public int getPageId(int i) {
        return this.pageIds.get(i);
    }

    public long getPageLsn(int i) {
        return this.pageLsns.get(i);
    }

    public int getPageIndex(int i) {
        return this.pageIndexes.get(i);
    }

    public void setPageLsn(int i, long pageLsn) {
        this.pageLsns.set(i, pageLsn);
    }

    public void moveFirst() {
        this.pageIds.moveFirst();
        this.pageLsns.moveFirst();
        this.pageIndexes.moveFirst();
    }

    public void moveLast() {
        this.pageIds.removeLast();
        this.pageLsns.removeLast();
        this.pageIndexes.removeLast();
    }

    public boolean isLast() {
        return this.pageIds.isLast();
    }

    public void clear() {
        this.pageIds.clear();
        this.pageLsns.clear();
        this.pageIndexes.clear();
    }

    public boolean isEmpty() {
        return this.pageIds.isEmpty();
    }
}

