/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.rtree.frames;

import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import edu.uci.ics.hyracks.storage.am.rtree.api.IRTreeLeafFrame;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreeNSMFrame;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreePolicyType;

public class RTreeNSMLeafFrame
extends RTreeNSMFrame
implements IRTreeLeafFrame {
    public RTreeNSMLeafFrame(ITreeIndexTupleWriter tupleWriter, IPrimitiveValueProvider[] keyValueProviders, RTreePolicyType rtreePolicyType) {
        super(tupleWriter, keyValueProviders, rtreePolicyType);
    }

    public int getBytesRequriedToWriteTuple(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple) + this.slotManager.getSlotSize();
    }

    public ITreeIndexTupleReference createTupleReference() {
        return this.tupleWriter.createTupleReference();
    }

    @Override
    public int findTupleIndex(ITupleReference tuple, MultiComparator cmp) {
        return this.slotManager.findTupleIndex(tuple, this.frameTuple, cmp, null, null);
    }

    @Override
    public boolean intersect(ITupleReference tuple, int tupleIndex, MultiComparator cmp) {
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, tupleIndex);
        int maxFieldPos = cmp.getKeyFieldCount() / 2;
        for (int i = 0; i < maxFieldPos; ++i) {
            int j = maxFieldPos + i;
            int c = cmp.getComparators()[i].compare(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i), this.frameTuple.getFieldData(j), this.frameTuple.getFieldStart(j), this.frameTuple.getFieldLength(j));
            if (c > 0) {
                return false;
            }
            c = cmp.getComparators()[i].compare(tuple.getFieldData(j), tuple.getFieldStart(j), tuple.getFieldLength(j), this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
            if (c >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTupleSize(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple);
    }

    public void insert(ITupleReference tuple, int tupleIndex) {
        this.slotManager.insertSlot(-1, this.buf.getInt(12));
        int bytesWritten = this.tupleWriter.writeTuple(tuple, this.buf.array(), this.buf.getInt(12));
        this.buf.putInt(8, this.buf.getInt(8) + 1);
        this.buf.putInt(12, this.buf.getInt(12) + bytesWritten);
        this.buf.putInt(16, this.buf.getInt(16) - bytesWritten - this.slotManager.getSlotSize());
    }

    @Override
    public void delete(int tupleIndex, MultiComparator cmp) {
        int slotOff = this.slotManager.getSlotOff(tupleIndex);
        int tupleOff = this.slotManager.getTupleOff(slotOff);
        this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
        int tupleSize = this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple);
        int slotStartOff = this.slotManager.getSlotEndOff();
        int length = slotOff - slotStartOff;
        System.arraycopy(this.buf.array(), slotStartOff, this.buf.array(), slotStartOff + this.slotManager.getSlotSize(), length);
        this.buf.putInt(8, this.buf.getInt(8) - 1);
        this.buf.putInt(16, this.buf.getInt(16) + tupleSize + this.slotManager.getSlotSize());
    }

    @Override
    public int getFieldCount() {
        return this.frameTuple.getFieldCount();
    }

    @Override
    public ITupleReference getBeforeTuple(ITupleReference tuple, int targetTupleIndex, MultiComparator cmp) {
        if (targetTupleIndex != this.slotManager.getGreatestKeyIndicator()) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, targetTupleIndex);
            if (cmp.compare(tuple, (ITupleReference)this.frameTuple) == 0) {
                return this.frameTuple;
            }
        }
        return null;
    }
}

